/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.query.engine;

import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import mx.com.hp.hpl.jena.query.core.Binding;
import mx.com.hp.hpl.jena.query.engine.QueryIterator;
import mx.com.hp.hpl.jena.query.util.Utils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class QueryIteratorBase
implements QueryIterator {
    private Log log = LogFactory.getLog(this.getClass());
    private boolean finished = false;
    boolean inGroup = true;

    protected abstract boolean hasNextBinding();

    protected abstract Binding moveToNextBinding();

    protected abstract void closeIterator();

    protected boolean isFinished() {
        return this.finished;
    }

    public QueryIterator nextClump() {
        if (!this.inGroup) {
            throw new NoSuchElementException("No more groups");
        }
        this.inGroup = false;
        return this;
    }

    public boolean hasNextClump() {
        return this.inGroup;
    }

    public List getClumpVars() {
        return new ArrayList();
    }

    public final boolean hasNext() {
        if (this.finished) {
            if (this.logp()) {
                this.logMsg("hasNext: already closed");
            }
            return false;
        }
        boolean r = this.hasNextBinding();
        if (!r) {
            if (this.logp()) {
                this.logMsg("hasNext: autoClose");
            }
            this.close();
        }
        if (this.logp()) {
            this.logMsg("hasNext: => " + (r ? "true" : "false"));
        }
        return r;
    }

    public final Object next() {
        return this.nextBinding();
    }

    public final Binding nextBinding() {
        if (this.finished) {
            if (this.logp()) {
                this.logMsg("next: already closed");
            }
            throw new NoSuchElementException();
        }
        if (!this.hasNextBinding()) {
            if (this.logp()) {
                this.logMsg("next: No more");
            }
            throw new NoSuchElementException(Utils.className(this));
        }
        Binding obj = this.moveToNextBinding();
        if (this.logp()) {
            this.logMsg("next: " + obj);
        }
        if (obj == null) {
            throw new NoSuchElementException(Utils.className(this));
        }
        return obj;
    }

    public final void remove() {
        this.getLog().warn((Object)("Call to QueryIterator.remove() : " + Utils.className(this) + ".remove"));
        throw new UnsupportedOperationException(Utils.className(this) + ".remove");
    }

    public void close() {
        if (this.finished) {
            return;
        }
        this.closeIterator();
        this.finished = true;
    }

    public String toString() {
        return Utils.className(this);
    }

    private Log getLog() {
        return this.log;
    }

    private boolean logp() {
        if (this.log == null) {
            return false;
        }
        return this.log.isDebugEnabled();
    }

    private void logMsg(String msg) {
        if (this.log == null) {
            return;
        }
        this.log.debug((Object)msg);
    }
}

