/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.query.engine1;

import java.io.OutputStream;
import java.util.Collection;
import java.util.Iterator;
import mx.com.hp.hpl.jena.graph.Node;
import mx.com.hp.hpl.jena.graph.Triple;
import mx.com.hp.hpl.jena.query.Query;
import mx.com.hp.hpl.jena.query.core.Constraint;
import mx.com.hp.hpl.jena.query.engine1.Plan;
import mx.com.hp.hpl.jena.query.engine1.PlanElement;
import mx.com.hp.hpl.jena.query.engine1.PlanVisitor;
import mx.com.hp.hpl.jena.query.engine1.compiler.PlanBasePattern;
import mx.com.hp.hpl.jena.query.engine1.compiler.PlanBlock;
import mx.com.hp.hpl.jena.query.engine1.compiler.PlanDistinct;
import mx.com.hp.hpl.jena.query.engine1.compiler.PlanExtension;
import mx.com.hp.hpl.jena.query.engine1.compiler.PlanFilter;
import mx.com.hp.hpl.jena.query.engine1.compiler.PlanGroup;
import mx.com.hp.hpl.jena.query.engine1.compiler.PlanLimitOffset;
import mx.com.hp.hpl.jena.query.engine1.compiler.PlanNamedGraph;
import mx.com.hp.hpl.jena.query.engine1.compiler.PlanOptional;
import mx.com.hp.hpl.jena.query.engine1.compiler.PlanOrderBy;
import mx.com.hp.hpl.jena.query.engine1.compiler.PlanOuterJoin;
import mx.com.hp.hpl.jena.query.engine1.compiler.PlanProject;
import mx.com.hp.hpl.jena.query.engine1.compiler.PlanTriplePattern;
import mx.com.hp.hpl.jena.query.engine1.compiler.PlanUnion;
import mx.com.hp.hpl.jena.query.engine1.compiler.PlanUnsaid;
import mx.com.hp.hpl.jena.query.expr.Expr;
import mx.com.hp.hpl.jena.query.serializer.FmtExprARQ;
import mx.com.hp.hpl.jena.query.serializer.SerializationContext;
import mx.com.hp.hpl.jena.query.util.FmtUtils;
import mx.com.hp.hpl.jena.query.util.IndentedWriter;
import mx.com.hp.hpl.jena.shared.PrefixMapping;

public class PlanFormatter
implements PlanVisitor {
    static final int INDENT = 2;
    IndentedWriter out;
    SerializationContext context;
    private static boolean defaultClosingBracketOnSameLine = true;
    private boolean closingBracketOnSameLine = defaultClosingBracketOnSameLine;

    public static void out(OutputStream outStream, Plan plan) {
        PlanFormatter.out(outStream, plan.getRoot());
    }

    public static void out(IndentedWriter w, Plan plan) {
        PlanFormatter.out(w, plan.getRoot());
    }

    public static void out(OutputStream outStream, Query query2, Plan plan) {
        PlanFormatter.out(outStream, plan.getRoot());
    }

    public static void out(OutputStream outStream, PrefixMapping pmap, Plan plan) {
        PlanFormatter.out(outStream, pmap, plan.getRoot());
    }

    public static void out(IndentedWriter w, PlanElement pElt) {
        PlanFormatter.out(w, (PrefixMapping)null, pElt);
    }

    public static void out(OutputStream outStream, PlanElement pElt) {
        PlanFormatter.out(outStream, (PrefixMapping)null, pElt);
    }

    public static void out(OutputStream outStream, PrefixMapping pmap, PlanElement pElt) {
        IndentedWriter w = new IndentedWriter(outStream);
        PlanFormatter.out(w, pmap, pElt);
    }

    public static void out(OutputStream outStream, Query query2, PlanElement pElt) {
        IndentedWriter w = new IndentedWriter(outStream);
        PlanFormatter.out(w, query2, pElt);
    }

    public static void out(IndentedWriter w, Query query2, PlanElement pElt) {
        PrefixMapping pmap = null;
        if (query2 != null && query2.getPrefixMapping() != null) {
            pmap = query2.getPrefixMapping();
        }
        PlanFormatter.out(w, pmap, pElt);
    }

    public static void out(IndentedWriter w, PrefixMapping pmap, PlanElement pElt) {
        PlanFormatter fmt = new PlanFormatter(w, pmap);
        fmt.startVisit();
        pElt.visit(fmt);
        fmt.finishVisit();
    }

    private void startVisit() {
    }

    private void finishVisit() {
        this.out.newline();
        this.out.flush();
    }

    public PlanFormatter(IndentedWriter w, PrefixMapping pmap) {
        this(w, new SerializationContext(pmap));
    }

    public PlanFormatter(IndentedWriter w, SerializationContext context) {
        this.out = w;
        this.context = context;
        this.closingBracketOnSameLine = defaultClosingBracketOnSameLine;
    }

    public void visit(PlanBasePattern planElt) {
        this.out.print("[");
        this.out.print("BasePattern");
        if (planElt.getPattern().size() == 1) {
            this.out.print(" ");
            Triple t = (Triple)planElt.getPattern().get(0);
            this.formatTriple(t);
            this.finish();
            return;
        }
        this.out.incIndent(2);
        Iterator iter = planElt.getPattern().iterator();
        while (iter.hasNext()) {
            this.out.newline();
            Triple t = (Triple)iter.next();
            this.formatTriple(t);
        }
        if (this.closingBracketOnSameLine) {
            this.out.newline();
        }
        this.out.decIndent(2);
        this.finish();
    }

    public void visit(PlanTriplePattern planElt) {
        this.out.print("[");
        this.out.print("TriplePattern");
        this.out.print(" ");
        Triple t = planElt.getTriple();
        this.formatTriple(t);
        this.finish();
    }

    public void visit(PlanGroup planElt) {
        String s = "Group";
        if (!planElt.canReorder()) {
            s = "Group(fixed)";
        }
        this.multipleSubPlans(s, planElt.getPlanElements().iterator());
    }

    public void visit(PlanUnion planElt) {
        this.multipleSubPlans("Union", planElt.getPlanElements().iterator());
    }

    public void visit(PlanOptional planElt) {
        this.singleSubPlan("Optional", planElt.getSub());
    }

    public void visit(PlanUnsaid planElt) {
        this.singleSubPlan("Unsaid", planElt.getSub());
    }

    public void visit(PlanFilter planElt) {
        this.out.print("[");
        this.out.print("Constraint");
        this.out.print(" ");
        Constraint c = planElt.getConstraint();
        if (c instanceof Expr) {
            Expr expr = (Expr)c;
            FmtExprARQ v = new FmtExprARQ(this.out, this.context);
            expr.visit(v);
        } else {
            this.out.print(c.toString());
        }
        this.out.print("]");
    }

    public void visit(PlanNamedGraph planElt) {
        this.singleSubPlan("NamedGraph", planElt.getSub());
    }

    public void visit(PlanOuterJoin planElt) {
        this.multipleSubPlans("OuterJoin", planElt.getPlanElements().iterator());
    }

    public void visit(PlanExtension planElt) {
        this.plainPlan("Extension");
    }

    public void visit(PlanBlock planElt) {
        this.singleSubPlan("Block", planElt.getSub());
    }

    public void visit(PlanDistinct planElt) {
        this.singleSubPlan("Distinct", planElt.getSub(), planElt.getVars());
    }

    public void visit(PlanProject planElt) {
        this.singleSubPlan("Project", planElt.getSub(), planElt.getVars());
    }

    public void visit(PlanOrderBy planElt) {
        this.singleSubPlan("OrderBy", planElt.getSub());
    }

    public void visit(PlanLimitOffset planElt) {
        this.singleSubPlan("LimitOffset", planElt.getSub());
    }

    private void plainPlan(String label) {
        this.out.print("[");
        this.out.print(label);
        this.finish();
    }

    private void singleSubPlan(String label, PlanElement subElt) {
        this.singleSubPlan(label, subElt, null);
    }

    private void singleSubPlan(String label, PlanElement subElt, Collection vars) {
        this.out.print("[");
        this.out.print(label);
        if (vars != null) {
            Iterator iter = vars.iterator();
            while (iter.hasNext()) {
                String vn = (String)iter.next();
                this.out.print(" ?");
                this.out.print(vn);
            }
        }
        this.out.incIndent(2);
        if (subElt != null) {
            this.out.println();
            subElt.visit(this);
        }
        this.out.decIndent(2);
        this.finish();
    }

    private void multipleSubPlans(String label, Iterator iter) {
        this.out.print("[");
        this.out.print(label);
        this.out.incIndent(2);
        while (iter.hasNext()) {
            this.out.newline();
            PlanElement element = (PlanElement)iter.next();
            element.visit(this);
        }
        this.out.decIndent(2);
        this.finish();
    }

    private void finish() {
        if (this.closingBracketOnSameLine) {
            this.out.print("]");
        } else {
            this.out.println();
            this.out.print("]");
        }
    }

    private void formatTriple(Triple tp) {
        this.out.print(this.slotToString(tp.getSubject()));
        this.out.print(" ");
        this.out.print(this.slotToString(tp.getPredicate()));
        this.out.print(" ");
        this.out.print(this.slotToString(tp.getObject()));
    }

    private String slotToString(Node n) {
        return FmtUtils.stringForNode(n, this.context);
    }
}

