/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.query.engine1;

import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import mx.com.hp.hpl.jena.graph.Node;
import mx.com.hp.hpl.jena.graph.Node_Variable;
import mx.com.hp.hpl.jena.graph.Triple;
import mx.com.hp.hpl.jena.graph.query.Expression;
import mx.com.hp.hpl.jena.graph.query.Query;
import mx.com.hp.hpl.jena.query.core.Binding;
import mx.com.hp.hpl.jena.query.core.Constraint;
import mx.com.hp.hpl.jena.query.util.NodeUtils;
import mx.com.hp.hpl.jena.rdf.model.Model;
import mx.com.hp.hpl.jena.rdf.model.Property;
import mx.com.hp.hpl.jena.rdf.model.RDFNode;
import mx.com.hp.hpl.jena.rdf.model.Resource;
import mx.com.hp.hpl.jena.rdf.model.Statement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class QueryEngineUtils {
    public static Log log = LogFactory.getLog((Class)QueryEngineUtils.class);

    public static void compilePattern(Query graphQuery, List pattern, Binding presets, Set vars) {
        if (pattern == null) {
            return;
        }
        ListIterator iter = pattern.listIterator();
        while (iter.hasNext()) {
            Triple t = (Triple)iter.next();
            t = QueryEngineUtils.substituteIntoTriple(t, presets);
            if (vars != null) {
                if (t.getSubject().isVariable()) {
                    vars.add(t.getSubject());
                }
                if (t.getPredicate().isVariable()) {
                    vars.add(t.getPredicate());
                }
                if (t.getObject().isVariable()) {
                    vars.add(t.getObject());
                }
            }
            graphQuery.addMatch(t);
        }
    }

    public static void compileConstraints(Query graphQuery, List constraints) {
        if (constraints == null) {
            return;
        }
        Iterator cIter = constraints.iterator();
        while (cIter.hasNext()) {
            Constraint constraint = (Constraint)cIter.next();
            if (constraint instanceof Expression) {
                Expression e2 = (Expression)constraint;
                graphQuery.addConstraint(e2);
                continue;
            }
            log.warn((Object)("Query constraint '" + constraint + "' is not an expression"));
        }
    }

    public static Triple substituteIntoTriple(Triple t, Binding binding) {
        Node subject = QueryEngineUtils.substituteNode(t.getSubject(), binding);
        Node predicate = QueryEngineUtils.substituteNode(t.getPredicate(), binding);
        Node object = QueryEngineUtils.substituteNode(t.getObject(), binding);
        if (subject == t.getSubject() && predicate == t.getPredicate() && object == t.getObject()) {
            return t;
        }
        return new Triple(subject, predicate, object);
    }

    public static Node substituteNode(Node n, Binding binding) {
        if (!n.isVariable()) {
            return n;
        }
        String name = ((Node_Variable)n).getName();
        Node obj = null;
        if (binding != null) {
            obj = binding.get(name);
        }
        if (obj == null) {
            return n;
        }
        if (obj instanceof Node) {
            return obj;
        }
        log.warn((Object)("Unknown object in binding: ignored: " + obj.getClass().getName()));
        return n;
    }

    public static Node[] projectionVars(Set vars) {
        Node[] result = new Node[vars.size()];
        int i = 0;
        Iterator iter = vars.iterator();
        while (iter.hasNext()) {
            Node n;
            result[i] = n = (Node)iter.next();
            ++i;
        }
        return result;
    }

    public static Statement tripleToStatement(Model model, Triple t) {
        Node sNode = t.getSubject();
        Node pNode = t.getPredicate();
        Node oNode = t.getObject();
        if (sNode.isLiteral() || sNode.isVariable()) {
            return null;
        }
        if (!pNode.isURI()) {
            return null;
        }
        if (oNode.isVariable()) {
            return null;
        }
        RDFNode s = NodeUtils.convertGraphNodeToRDFNode(sNode, model);
        RDFNode p = NodeUtils.convertGraphNodeToRDFNode(pNode, model);
        if (p instanceof Resource) {
            p = model.createProperty(((Resource)p).getURI());
        }
        RDFNode o = NodeUtils.convertGraphNodeToRDFNode(oNode, model);
        Statement stmt = model.createStatement((Resource)s, (Property)p, o);
        return stmt;
    }
}

