/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.query.engine1;

import java.util.HashSet;
import java.util.List;
import mx.com.hp.hpl.jena.graph.Node;
import mx.com.hp.hpl.jena.graph.query.BindingQueryPlan;
import mx.com.hp.hpl.jena.graph.query.Domain;
import mx.com.hp.hpl.jena.graph.query.Query;
import mx.com.hp.hpl.jena.graph.query.QueryHandler;
import mx.com.hp.hpl.jena.query.core.Binding;
import mx.com.hp.hpl.jena.query.core.BindingMap;
import mx.com.hp.hpl.jena.query.core.DatasetGraph;
import mx.com.hp.hpl.jena.query.engine.QueryIterator;
import mx.com.hp.hpl.jena.query.engine1.ExecutionContext;
import mx.com.hp.hpl.jena.query.engine1.QueryEngineUtils;
import mx.com.hp.hpl.jena.query.engine1.QueryIter;
import mx.com.hp.hpl.jena.query.engine1.QueryIterRepeatApply;
import mx.com.hp.hpl.jena.util.iterator.ClosableIterator;
import org.apache.commons.logging.LogFactory;

public class QueryIterBasePattern
extends QueryIterRepeatApply {
    List pattern;
    List constraints = null;
    static /* synthetic */ Class class$mx$com$hp$hpl$jena$query$engine1$QueryIterBasePattern$StageBasePattern;

    public QueryIterBasePattern(QueryIterator input, List pattern, ExecutionContext cxt) {
        this(input, pattern, null, cxt);
    }

    public QueryIterBasePattern(QueryIterator input, List pattern, List constraints, ExecutionContext cxt) {
        super(input, cxt);
        this.pattern = pattern;
        this.constraints = constraints;
    }

    public QueryIterator nextStage(Binding binding) {
        return new StageBasePattern(binding, this.pattern, this.constraints, this.getExecContext());
    }

    private static Binding graphResultsToBinding(Binding parent, Domain d, Node[] projectionVars) {
        BindingMap binding = new BindingMap(parent);
        for (int i = 0; i < projectionVars.length; ++i) {
            String name = projectionVars[i].getName();
            Node n = (Node)d.get(i);
            if (n == null) continue;
            binding.add(name, n);
        }
        return binding;
    }

    static class StageBasePattern
    extends QueryIter {
        ClosableIterator graphIter;
        Binding binding;
        DatasetGraph data;
        Node[] projectionVars;

        public StageBasePattern(Binding binding, List pattern, List constraints, ExecutionContext qCxt) {
            super(qCxt);
            this.binding = binding;
            QueryHandler qh = qCxt.getActiveGraph().queryHandler();
            Query graphQuery = new Query();
            HashSet vars = new HashSet();
            QueryEngineUtils.compilePattern(graphQuery, pattern, binding, vars);
            this.projectionVars = QueryEngineUtils.projectionVars(vars);
            QueryEngineUtils.compileConstraints(graphQuery, constraints);
            BindingQueryPlan plan = qh.prepareBindings(graphQuery, this.projectionVars);
            this.graphIter = plan.executeBindings();
            if (this.graphIter == null) {
                LogFactory.getLog((Class)(class$mx$com$hp$hpl$jena$query$engine1$QueryIterBasePattern$StageBasePattern == null ? (class$mx$com$hp$hpl$jena$query$engine1$QueryIterBasePattern$StageBasePattern = QueryIterBasePattern.class$("mx.com.hp.hpl.jena.query.engine1.QueryIterBasePattern$StageBasePattern")) : class$mx$com$hp$hpl$jena$query$engine1$QueryIterBasePattern$StageBasePattern)).warn((Object)"Graph Iterator is null");
            }
        }

        protected boolean hasNextBinding() {
            boolean isMore = this.graphIter.hasNext();
            return isMore;
        }

        protected Binding moveToNextBinding() {
            Domain d = (Domain)this.graphIter.next();
            Binding b = QueryIterBasePattern.graphResultsToBinding(this.binding, d, this.projectionVars);
            return b;
        }

        protected void closeIterator() {
            if (!this.isFinished()) {
                if (this.graphIter != null) {
                    this.graphIter.close();
                }
                this.graphIter = null;
            }
        }
    }
}

