/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.query.engine1;

import java.util.Iterator;
import mx.com.hp.hpl.jena.graph.Node;
import mx.com.hp.hpl.jena.query.QueryExecException;
import mx.com.hp.hpl.jena.query.core.Binding;
import mx.com.hp.hpl.jena.query.core.DatasetGraph;
import mx.com.hp.hpl.jena.query.engine.QueryIterator;
import mx.com.hp.hpl.jena.query.engine1.ExecutionContext;
import mx.com.hp.hpl.jena.query.engine1.PlanElement;
import mx.com.hp.hpl.jena.query.engine1.QueryIterNamedGraphInner;
import mx.com.hp.hpl.jena.query.engine1.QueryIterRepeatApply;
import mx.com.hp.hpl.jena.util.iterator.SingletonIterator;

public class QueryIterNamedGraph
extends QueryIterRepeatApply {
    Node sourceNode;
    PlanElement subPattern;

    public QueryIterNamedGraph(QueryIterator input, Node _sourceNode, ExecutionContext context, PlanElement subComp) {
        super(input, context);
        this.sourceNode = _sourceNode;
        this.subPattern = subComp;
    }

    protected QueryIterator nextStage(Binding outerBinding) {
        DatasetGraph ds = this.getExecContext().getDataset();
        Iterator graphURIs = QueryIterNamedGraph.makeSources(ds, outerBinding, this.sourceNode);
        QueryIterNamedGraphInner current = new QueryIterNamedGraphInner(outerBinding, this.sourceNode, graphURIs, this.subPattern, this.getExecContext());
        return current;
    }

    private static Iterator makeSources(DatasetGraph data, Binding b, Node graphVar) {
        Node n2 = QueryIterNamedGraph.resolve(b, graphVar);
        if (n2 != null && !n2.isURI()) {
            throw new QueryExecException("GRAPH is not a URI: " + n2);
        }
        if (n2 == null) {
            return data.listNames();
        }
        return new SingletonIterator((Object)n2.getURI());
    }

    private static Node resolve(Binding b, Node n) {
        if (n == null) {
            return n;
        }
        if (!n.isVariable()) {
            return n;
        }
        if (b == null) {
            return null;
        }
        return b.get(n.getName());
    }
}

