/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.query.engine1;

import java.util.Iterator;
import java.util.NoSuchElementException;
import mx.com.hp.hpl.jena.graph.Graph;
import mx.com.hp.hpl.jena.graph.Node;
import mx.com.hp.hpl.jena.query.core.Binding;
import mx.com.hp.hpl.jena.query.core.Binding1;
import mx.com.hp.hpl.jena.query.engine.QueryIterator;
import mx.com.hp.hpl.jena.query.engine1.ExecutionContext;
import mx.com.hp.hpl.jena.query.engine1.PlanElement;
import mx.com.hp.hpl.jena.query.engine1.QueryIter;
import mx.com.hp.hpl.jena.query.engine1.QueryIterSingleton;
import mx.com.hp.hpl.jena.query.util.Utils;

public class QueryIterNamedGraphInner
extends QueryIter {
    Binding binding;
    Node graphNode;
    Iterator graphURIs;
    PlanElement cElt;
    QueryIterator subIter;
    boolean started = false;

    public QueryIterNamedGraphInner(Binding binding, Node sourceNode, Iterator _graphURIs, PlanElement cElt, ExecutionContext context) {
        super(context);
        this.graphURIs = _graphURIs;
        this.cElt = cElt;
        this.binding = binding;
        this.subIter = null;
        this.graphNode = sourceNode;
        this.started = false;
    }

    protected boolean hasNextBinding() {
        do {
            if (this.subIter == null) {
                this.subIter = this.nextIterator();
            }
            if (this.subIter == null) {
                return false;
            }
            if (this.subIter.hasNext()) {
                return true;
            }
            this.subIter.close();
            this.subIter = this.nextIterator();
        } while (this.subIter != null);
        return false;
    }

    protected Binding moveToNextBinding() {
        if (this.subIter == null) {
            throw new NoSuchElementException(Utils.className(this) + ".nextB");
        }
        return this.subIter.nextBinding();
    }

    protected void closeIterator() {
        if (this.subIter != null) {
            this.subIter.close();
        }
        this.subIter = null;
    }

    private QueryIterator nextIterator() {
        if (!this.graphURIs.hasNext()) {
            return null;
        }
        String uri = (String)this.graphURIs.next();
        Graph g = this.getExecContext().getDataset().getNamedGraph(uri);
        if (g == null) {
            return null;
        }
        ExecutionContext execCxt2 = new ExecutionContext(this.getExecContext(), g);
        Binding b = this.binding;
        if (this.graphNode != null && this.graphNode.isVariable()) {
            b = new Binding1(this.graphNode.getName(), Node.createURI((String)uri), this.binding);
        }
        QueryIterSingleton qIterOneBinding = new QueryIterSingleton(b, execCxt2);
        QueryIterator qIter = this.cElt.build(qIterOneBinding, execCxt2);
        return qIter;
    }
}

