/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.query.engine1;

import java.util.NoSuchElementException;
import mx.com.hp.hpl.jena.query.core.Binding;
import mx.com.hp.hpl.jena.query.engine.QueryIterator;
import mx.com.hp.hpl.jena.query.engine1.ExecutionContext;
import mx.com.hp.hpl.jena.query.engine1.QueryIter;
import mx.com.hp.hpl.jena.query.util.Utils;
import org.apache.commons.logging.LogFactory;

public abstract class QueryIterRepeatApply
extends QueryIter {
    int count = 0;
    QueryIterator input;
    QueryIterator currentStage;

    public QueryIterRepeatApply(QueryIterator _input, ExecutionContext context) {
        super(context);
        this.input = _input;
        this.currentStage = null;
        if (this.input == null) {
            LogFactory.getLog(this.getClass()).fatal((Object)"[QueryIterRepeatApply] Repeated application to null input iterator");
            return;
        }
    }

    protected abstract QueryIterator nextStage(Binding var1);

    protected boolean hasNextBinding() {
        if (this.isFinished()) {
            return false;
        }
        while (true) {
            if (this.currentStage == null) {
                this.currentStage = this.makeNextStage();
            }
            if (this.currentStage == null) {
                return false;
            }
            if (this.currentStage.hasNext()) {
                return true;
            }
            this.currentStage.close();
            this.currentStage = null;
        }
    }

    protected Binding moveToNextBinding() {
        if (!this.hasNextBinding()) {
            throw new NoSuchElementException(Utils.className(this) + ".next()/finished");
        }
        return this.currentStage.nextBinding();
    }

    private QueryIterator makeNextStage() {
        ++this.count;
        if (this.input == null) {
            return null;
        }
        if (!this.input.hasNext()) {
            this.input.close();
            this.input = null;
            return null;
        }
        Binding binding = (Binding)this.input.next();
        QueryIterator iter = this.nextStage(binding);
        return iter;
    }

    protected void closeIterator() {
        if (!this.isFinished()) {
            if (this.currentStage != null) {
                this.currentStage.close();
            }
            if (this.input != null) {
                this.input.close();
            }
            this.input = null;
        }
    }
}

