/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.query.engine1.analyse;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import mx.com.hp.hpl.jena.query.engine1.PlanElement;
import mx.com.hp.hpl.jena.query.engine1.PlanFormatter;
import mx.com.hp.hpl.jena.query.engine1.analyse.PlanVarsMentioned;
import mx.com.hp.hpl.jena.query.engine1.analyse.VarUsageVisitor;
import mx.com.hp.hpl.jena.query.engine1.compiler.PlanBasePattern;
import mx.com.hp.hpl.jena.query.engine1.compiler.PlanFilter;
import mx.com.hp.hpl.jena.query.engine1.compiler.PlanGroup;
import mx.com.hp.hpl.jena.query.engine1.compiler.PlanTriplePattern;
import mx.com.hp.hpl.jena.shared.PrefixMapping;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AnalyseFilters {
    static Log log = LogFactory.getLog((Class)AnalyseFilters.class);
    PlanGroup planGroup;
    List basePlanElements = new ArrayList();
    List filterPlanElements = new ArrayList();
    List unknownFilterPlanElements = new ArrayList();
    List otherPlanElements = new ArrayList();
    List ordered = new ArrayList();

    public AnalyseFilters(PlanGroup cElt) {
        this.planGroup = cElt;
        this.buildStructures();
        this.analyse();
    }

    private void buildStructures() {
        Iterator iter = this.planGroup.getPlanElements().iterator();
        while (iter.hasNext()) {
            PlanElement e2 = (PlanElement)iter.next();
            if (e2 instanceof PlanTriplePattern) {
                PlanTriplePattern tp = (PlanTriplePattern)e2;
                this.basePlanElements.add(tp);
                continue;
            }
            if (e2 instanceof PlanBasePattern) {
                PlanBasePattern bp = (PlanBasePattern)e2;
                this.basePlanElements.add(bp);
                continue;
            }
            if (e2 instanceof PlanFilter) {
                PlanFilter pc = (PlanFilter)e2;
                this.filterPlanElements.add(pc);
                continue;
            }
            this.otherPlanElements.add(e2);
        }
    }

    private void analyse() {
        HashSet varsFixed = new HashSet();
        this.insertFilters(varsFixed);
        Iterator iter = this.basePlanElements.iterator();
        while (iter.hasNext()) {
            PlanBasePattern p = (PlanBasePattern)iter.next();
            VarUsageVisitor v = new VarUsageVisitor();
            p.visit(v);
            varsFixed.addAll(v.getFixedUsageVars());
            this.ordered.add(p);
            this.insertFilters(varsFixed);
        }
        this.unknownFilterPlanElements.addAll(this.filterPlanElements);
    }

    private void insertFilters(Set varsFixed) {
        Iterator iter2 = this.filterPlanElements.iterator();
        while (iter2.hasNext()) {
            PlanFilter pc = (PlanFilter)iter2.next();
            Set z = PlanVarsMentioned.varMentioned(pc);
            if (!varsFixed.containsAll(z)) continue;
            this.ordered.add(pc);
            iter2.remove();
        }
    }

    public void report(PrefixMapping pmap) {
        List x = this.reorder();
        Iterator iter = x.iterator();
        while (iter.hasNext()) {
            PlanElement p = (PlanElement)iter.next();
            PlanFormatter.out((OutputStream)System.out, pmap, p);
        }
    }

    public List reorder() {
        ArrayList x = new ArrayList();
        x.addAll(this.ordered);
        x.addAll(this.otherPlanElements);
        x.addAll(this.unknownFilterPlanElements);
        return x;
    }
}

