/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.query.engine1.analyse;

import java.util.HashSet;
import java.util.ListIterator;
import java.util.Set;
import mx.com.hp.hpl.jena.graph.Node;
import mx.com.hp.hpl.jena.graph.Triple;
import mx.com.hp.hpl.jena.query.engine1.PlanElement;
import mx.com.hp.hpl.jena.query.engine1.PlanVisitorBase;
import mx.com.hp.hpl.jena.query.engine1.PlanWalker;
import mx.com.hp.hpl.jena.query.engine1.compiler.PlanBasePattern;
import mx.com.hp.hpl.jena.query.engine1.compiler.PlanDistinct;
import mx.com.hp.hpl.jena.query.engine1.compiler.PlanFilter;
import mx.com.hp.hpl.jena.query.engine1.compiler.PlanGroup;
import mx.com.hp.hpl.jena.query.engine1.compiler.PlanNamedGraph;
import mx.com.hp.hpl.jena.query.engine1.compiler.PlanTriplePattern;

public class PlanVarsMentioned
extends PlanVisitorBase {
    Set acc;

    public static Set varMentioned(PlanElement planElt) {
        HashSet acc = new HashSet();
        PlanVarsMentioned v = new PlanVarsMentioned(acc);
        PlanWalker w = new PlanWalker(v);
        w.walk(planElt);
        return acc;
    }

    public PlanVarsMentioned(Set s) {
        this.acc = s;
    }

    public void visit(PlanBasePattern planElt) {
        ListIterator iter = planElt.triples();
        while (iter.hasNext()) {
            Triple t = (Triple)iter.next();
            PlanVarsMentioned.addVarsFromTriple(this.acc, t);
        }
    }

    public void visit(PlanTriplePattern planElt) {
        Triple t = planElt.getTriple();
        PlanVarsMentioned.addVarsFromTriple(this.acc, t);
    }

    public void visit(PlanGroup planElt) {
    }

    public void visit(PlanFilter planElt) {
        planElt.getConstraint().varsMentioned(this.acc);
    }

    public void visit(PlanNamedGraph planElt) {
        PlanVarsMentioned.addVar(this.acc, planElt.getElement().getGraphNameNode());
    }

    public void visit(PlanDistinct planElt) {
    }

    private static void addVarsFromTriple(Set acc, Triple t) {
        PlanVarsMentioned.addVar(acc, t.getSubject());
        PlanVarsMentioned.addVar(acc, t.getPredicate());
        PlanVarsMentioned.addVar(acc, t.getObject());
    }

    private static void addVar(Set acc, Node n) {
        if (n == null) {
            return;
        }
        if (n.isVariable()) {
            acc.add(n.getName());
        }
    }
}

