/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.query.engine1.compiler;

import mx.com.hp.hpl.jena.query.ARQ;
import mx.com.hp.hpl.jena.query.core.Constraint;
import mx.com.hp.hpl.jena.query.engine1.PlanElement;
import mx.com.hp.hpl.jena.query.engine1.compiler.JenaRegex;
import mx.com.hp.hpl.jena.query.engine1.compiler.PlanBasePattern;
import mx.com.hp.hpl.jena.query.engine1.compiler.PlanFilter;
import mx.com.hp.hpl.jena.query.expr.E_Regex;
import mx.com.hp.hpl.jena.query.expr.NodeValue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GroupUtils {
    static Log log = LogFactory.getLog((Class)GroupUtils.class);

    static boolean optimizableConstraint(PlanBasePattern basePatterns, PlanElement e2) {
        String flags;
        if (!ARQ.getContext().isTrue(ARQ.enableRegexConstraintsOpt)) {
            return false;
        }
        if (!(e2 instanceof PlanFilter)) {
            return false;
        }
        PlanFilter f = (PlanFilter)e2;
        Constraint c = f.getConstraint();
        if (!(c instanceof E_Regex)) {
            return false;
        }
        E_Regex regex = (E_Regex)c;
        if (!regex.getExpr().isVariable()) {
            return false;
        }
        String var = regex.getExpr().getVarName();
        if (!regex.getPattern().isConstant()) {
            return false;
        }
        if (regex.getFlags() != null && !regex.getFlags().isConstant()) {
            return false;
        }
        NodeValue patternNV = regex.getPattern().getConstant();
        if (!patternNV.isString()) {
            return false;
        }
        NodeValue flagsNV = null;
        if (regex.getFlags() != null) {
            flagsNV = regex.getFlags().getConstant();
        }
        if (flagsNV != null && !flagsNV.isString()) {
            return false;
        }
        String pattern = patternNV.getString();
        String string = flags = flagsNV == null ? null : flagsNV.getString();
        if (log.isDebugEnabled()) {
            log.debug((Object)("REGEX: " + var + " '" + pattern + "' '" + flags + "'"));
        }
        JenaRegex jenaExpr = new JenaRegex(regex, var, pattern, flags);
        basePatterns.addConstraint(jenaExpr);
        return true;
    }
}

