/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.query.engine1.compiler;

import java.util.Set;
import mx.com.hp.hpl.jena.graph.Node;
import mx.com.hp.hpl.jena.graph.query.Expression;
import mx.com.hp.hpl.jena.graph.query.IndexValues;
import mx.com.hp.hpl.jena.graph.query.Valuator;
import mx.com.hp.hpl.jena.graph.query.VariableIndexes;
import mx.com.hp.hpl.jena.query.core.Binding;
import mx.com.hp.hpl.jena.query.core.Constraint;
import mx.com.hp.hpl.jena.query.engine1.ExecutionContext;
import mx.com.hp.hpl.jena.query.engine1.compiler.PatternLiteralImpl;
import mx.com.hp.hpl.jena.query.engine1.compiler.Var;
import mx.com.hp.hpl.jena.query.expr.E_Regex;
import mx.com.hp.hpl.jena.query.util.Utils;
import mx.com.hp.hpl.jena.shared.JenaException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternCompiler;
import org.apache.oro.text.regex.PatternMatcher;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;

public class JenaRegex
implements Expression,
Valuator,
Constraint {
    private static Log log = LogFactory.getLog((Class)JenaRegex.class);
    public static String regexSystem = "urn:x-jena:expr:Q_StringMatch";
    public static String regexLanguage = "http://jena.hpl.hp.com/2003/07/query/RDQL";
    E_Regex regex;
    Var var;
    PatternLiteralImpl patternLiteral;
    PatternCompiler compiler = new Perl5Compiler();
    PatternMatcher matcher = new Perl5Matcher();
    Pattern pattern;

    JenaRegex(E_Regex regex, String var, String pat, String flags) {
        if (flags == null) {
            flags = "";
        }
        this.regex = regex;
        this.var = new Var(var);
        this.patternLiteral = new PatternLiteralImpl(pat, flags);
        try {
            this.pattern = this.compiler.compile(pat, JenaRegex.getMask(flags));
        }
        catch (Exception pEx) {
            throw new JenaException("JenaRegex: Pattern exception: " + pEx);
        }
    }

    public boolean isApply() {
        return true;
    }

    public String getFun() {
        return regexSystem;
    }

    public int argCount() {
        return 2;
    }

    public Expression getArg(int i) {
        if (i == 0) {
            return this.var;
        }
        if (i == 1) {
            return this.patternLiteral;
        }
        return null;
    }

    public boolean isVariable() {
        return false;
    }

    public String getName() {
        return null;
    }

    public boolean isConstant() {
        return false;
    }

    public Object getValue() {
        return null;
    }

    public Valuator prepare(VariableIndexes vi) {
        this.var.prepare(vi);
        this.patternLiteral.prepare(vi);
        return this;
    }

    public Object evalObject(IndexValues iv) {
        log.warn((Object)("Unexpexpected call to " + Utils.className(this) + ".evalObject - expected only evalBool calls"));
        boolean b = this.evalBool(iv);
        return new Boolean(b);
    }

    public boolean evalBool(IndexValues iv) {
        Object obj = this.var.evalObject(iv);
        Node n = (Node)obj;
        if (log.isDebugEnabled()) {
            log.debug((Object)("evalBool " + this.patternLiteral.getPatternString() + " // " + n));
        }
        if (!n.isLiteral()) {
            return false;
        }
        if (n.getLiteralDatatypeURI() != null) {
            return false;
        }
        if (n.getLiteralLanguage() != null && !n.getLiteralLanguage().equals("")) {
            return false;
        }
        String xx = n.getLiteralLexicalForm();
        boolean b = this.matcher.contains(xx, this.pattern);
        return b;
    }

    private static int getMask(String mod) {
        if (mod == null) {
            return 0;
        }
        int mask = 0;
        block6: for (int i = 0; i < mod.length(); ++i) {
            switch (mod.charAt(i)) {
                case 'i': {
                    mask |= 1;
                    continue block6;
                }
                case 'm': {
                    mask |= 8;
                    continue block6;
                }
                case 's': {
                    mask |= 0x10;
                    continue block6;
                }
                case 'x': {
                    mask |= 0x20;
                }
            }
        }
        return mask;
    }

    public boolean isSatisfied(Binding binding, ExecutionContext execCxt) {
        return this.regex.isSatisfied(binding, execCxt);
    }

    public void varsMentioned(Set acc) {
        acc.add(this.var.getName());
    }
}

