/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.query.engine1.compiler;

import mx.com.hp.hpl.jena.query.Query;
import mx.com.hp.hpl.jena.query.engine.QueryIterator;
import mx.com.hp.hpl.jena.query.engine1.ExecutionContext;
import mx.com.hp.hpl.jena.query.engine1.Plan;
import mx.com.hp.hpl.jena.query.engine1.PlanElement;
import mx.com.hp.hpl.jena.query.engine1.PlanVisitor;
import mx.com.hp.hpl.jena.query.engine1.QueryIterLimitOffset;
import mx.com.hp.hpl.jena.query.engine1.compiler.PlanSequenceModifier;

public class PlanLimitOffset
extends PlanSequenceModifier {
    long limit;
    long offset;

    public static PlanElement make(Plan plan, PlanElement cElt, long limit, long offset) {
        return new PlanLimitOffset(plan, cElt, limit, offset);
    }

    private PlanLimitOffset(Plan plan, PlanElement cElt, long limit, long offset) {
        super(plan, cElt);
        this.limit = limit;
        this.offset = offset;
    }

    QueryIterator execModifer(QueryIterator qIter, ExecutionContext context) {
        long posn;
        long num = this.limit;
        if (num == Query.NOLIMIT) {
            num = Long.MAX_VALUE;
        }
        if ((posn = this.offset) == Query.NOLIMIT) {
            posn = 0L;
        }
        qIter = new QueryIterLimitOffset(qIter, num, posn, context);
        return qIter;
    }

    public void visit(PlanVisitor visitor) {
        visitor.visit(this);
    }
}

