/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.query.engine1.compiler;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import mx.com.hp.hpl.jena.query.engine.QueryIterator;
import mx.com.hp.hpl.jena.query.engine1.ExecutionContext;
import mx.com.hp.hpl.jena.query.engine1.Plan;
import mx.com.hp.hpl.jena.query.engine1.PlanElement;
import mx.com.hp.hpl.jena.query.engine1.PlanVisitor;
import mx.com.hp.hpl.jena.query.engine1.analyse.PlanVarsMentioned;
import mx.com.hp.hpl.jena.query.engine1.compiler.PlanDistinct;
import mx.com.hp.hpl.jena.query.engine1.compiler.PlanElementBase;
import mx.com.hp.hpl.jena.query.engine1.compiler.PlanGroup;
import mx.com.hp.hpl.jena.query.engine1.compiler.PlanUnion;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PlanOuterJoin
extends PlanElementBase {
    static Log log = LogFactory.getLog((Class)PlanOuterJoin.class);
    Set planElements;
    PlanElement planElement;

    public static PlanElement make(Plan plan, Set equiv) {
        PlanElement p = PlanOuterJoin.permute(plan, equiv);
        Set vars = PlanVarsMentioned.varMentioned(p);
        p = PlanDistinct.make(plan, p, vars);
        return p;
    }

    private PlanOuterJoin(Plan plan, Set planElements) {
        super(plan);
        this.planElements = planElements;
        this.planElement = PlanOuterJoin.permute(this.getPlan(), planElements);
    }

    public Set getPlanElements() {
        return this.planElements;
    }

    public QueryIterator build(QueryIterator input, ExecutionContext execCxt) {
        return this.planElement.build(input, execCxt);
    }

    private static PlanElement permute(Plan plan, Set planElements) {
        if (planElements.size() != 2) {
            log.fatal((Object)("Can only permute 2 elements - not " + planElements.size()));
            return null;
        }
        Iterator iter = planElements.iterator();
        PlanElement x1 = (PlanElement)iter.next();
        PlanElement x2 = (PlanElement)iter.next();
        ArrayList<PlanElement> u1 = new ArrayList<PlanElement>();
        u1.add(x1);
        u1.add(x2);
        PlanGroup pg1 = PlanGroup.make(plan, u1, false);
        ArrayList<PlanElement> u2 = new ArrayList<PlanElement>();
        u2.add(x2);
        u2.add(x1);
        PlanGroup pg2 = PlanGroup.make(plan, u2, false);
        ArrayList<PlanGroup> u = new ArrayList<PlanGroup>();
        u.add(pg1);
        u.add(pg2);
        PlanElement pUnion = PlanUnion.make(plan, u);
        return pUnion;
    }

    public void visit(PlanVisitor visitor) {
        visitor.visit(this);
    }
}

