/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.query.engine1.compiler;

import java.util.ArrayList;
import java.util.Stack;
import mx.com.hp.hpl.jena.query.core.ARQInternalErrorException;
import mx.com.hp.hpl.jena.query.core.Element;
import mx.com.hp.hpl.jena.query.core.ElementBlock;
import mx.com.hp.hpl.jena.query.core.ElementExtension;
import mx.com.hp.hpl.jena.query.core.ElementFilter;
import mx.com.hp.hpl.jena.query.core.ElementGroup;
import mx.com.hp.hpl.jena.query.core.ElementNamedGraph;
import mx.com.hp.hpl.jena.query.core.ElementOptional;
import mx.com.hp.hpl.jena.query.core.ElementTriplePattern;
import mx.com.hp.hpl.jena.query.core.ElementUnion;
import mx.com.hp.hpl.jena.query.core.ElementUnsaid;
import mx.com.hp.hpl.jena.query.core.ElementVisitor;
import mx.com.hp.hpl.jena.query.core.ElementWalker;
import mx.com.hp.hpl.jena.query.engine1.Plan;
import mx.com.hp.hpl.jena.query.engine1.PlanElement;
import mx.com.hp.hpl.jena.query.engine1.compiler.PlanBlock;
import mx.com.hp.hpl.jena.query.engine1.compiler.PlanExtension;
import mx.com.hp.hpl.jena.query.engine1.compiler.PlanFilter;
import mx.com.hp.hpl.jena.query.engine1.compiler.PlanGroup;
import mx.com.hp.hpl.jena.query.engine1.compiler.PlanNamedGraph;
import mx.com.hp.hpl.jena.query.engine1.compiler.PlanOptional;
import mx.com.hp.hpl.jena.query.engine1.compiler.PlanTriplePattern;
import mx.com.hp.hpl.jena.query.engine1.compiler.PlanUnion;
import mx.com.hp.hpl.jena.query.engine1.compiler.PlanUnsaid;

public class QueryCompilerVisitor
implements ElementVisitor {
    protected Plan plan = null;
    private Stack retStack = new Stack();

    public QueryCompilerVisitor(Plan plan) {
        this.plan = plan;
    }

    public PlanElement compile(Element el) {
        ElementWalker.walk(el, this);
        if (this.retStack.size() != 1) {
            throw new ARQInternalErrorException("Plan compilation stack is not the expected size");
        }
        PlanElement cElt = (PlanElement)this.retStack.pop();
        return cElt;
    }

    public void visit(ElementTriplePattern el) {
        PlanElement cElt = PlanTriplePattern.make(this.plan, el);
        this.push(cElt);
    }

    public void visit(ElementFilter el) {
        PlanElement cElt = PlanFilter.make(this.plan, el);
        this.push(cElt);
    }

    public void visit(ElementUnion el) {
        ArrayList<PlanElement> acc = new ArrayList<PlanElement>();
        int x = el.getElements().size();
        int z1 = this.retStack.size();
        for (int i = 0; i < x; ++i) {
            PlanElement ex2 = this.pop();
            acc.add(0, ex2);
        }
        int z2 = this.retStack.size();
        PlanElement ex = PlanUnion.make(this.plan, acc);
        this.push(ex);
    }

    public void visit(ElementGroup el) {
        ArrayList<PlanElement> acc = new ArrayList<PlanElement>();
        int x = el.getElements().size();
        for (int i = 0; i < x; ++i) {
            PlanElement ex2 = this.pop();
            acc.add(0, ex2);
        }
        PlanElement ex = PlanGroup.make(this.plan, acc);
        this.push(ex);
    }

    public void visit(ElementBlock el) {
        PlanElement cSubElt = null;
        if (el.getPatternElement() != null) {
            cSubElt = this.pop();
        }
        PlanElement cElt = PlanBlock.make(this.plan, el, cSubElt);
        this.push(cElt);
    }

    public void visit(ElementOptional el) {
        PlanElement cSubElt = this.pop();
        PlanElement cElt = PlanOptional.make(this.plan, el, cSubElt);
        this.push(cElt);
    }

    public void visit(ElementNamedGraph el) {
        PlanElement cSubElt = this.pop();
        PlanElement cElt = PlanNamedGraph.make(this.plan, el, cSubElt);
        this.push(cElt);
    }

    public void visit(ElementUnsaid el) {
        PlanElement cSubElt = this.pop();
        PlanElement cElt = PlanUnsaid.make(this.plan, el, cSubElt);
        this.push(cElt);
    }

    public void visit(ElementExtension el) {
        PlanElement cElt = PlanExtension.make(this.plan, el);
        this.push(cElt);
    }

    private void push(PlanElement cElt) {
        this.retStack.push(cElt);
    }

    private PlanElement pop() {
        return (PlanElement)this.retStack.pop();
    }
}

