/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.query.engineHTTP;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import mx.com.hp.hpl.jena.query.Query;
import mx.com.hp.hpl.jena.query.QueryExecException;
import mx.com.hp.hpl.jena.query.QueryExecution;
import mx.com.hp.hpl.jena.query.QuerySolution;
import mx.com.hp.hpl.jena.query.ResultSet;
import mx.com.hp.hpl.jena.query.ResultSetFactory;
import mx.com.hp.hpl.jena.query.engineHTTP.HttpQuery;
import mx.com.hp.hpl.jena.query.resultset.XMLInputStAX;
import mx.com.hp.hpl.jena.query.util.Context;
import mx.com.hp.hpl.jena.rdf.model.Model;
import mx.com.hp.hpl.jena.rdf.model.ModelFactory;
import mx.com.hp.hpl.jena.util.FileManager;

public class QueryEngineHTTP
implements QueryExecution {
    String queryString;
    String service;
    Context parameters = new Context();
    List defaultGraphURIs = new ArrayList();
    List namedGraphURIs = new ArrayList();

    public QueryEngineHTTP(String serviceURI, Query query2) {
        this.queryString = query2.toString();
        this.service = serviceURI;
    }

    public QueryEngineHTTP(String serviceURI, String queryString) {
        this.queryString = queryString;
        this.service = serviceURI;
    }

    public void setFileManager(FileManager fm) {
    }

    public void setInitialBinding(QuerySolution binding) {
        throw new QueryExecException("Initial bindings not supportd for remote queries");
    }

    public void setDefaultGraphURIs(List defaultGraphURIs) {
        this.defaultGraphURIs = defaultGraphURIs;
    }

    public void setNamedGraphURIs(List namedGraphURIs) {
        this.namedGraphURIs = namedGraphURIs;
    }

    public void addDefaultGraph(String defaultGraph) {
        if (this.defaultGraphURIs == null) {
            this.defaultGraphURIs = new ArrayList();
        }
        this.defaultGraphURIs.add(defaultGraph);
    }

    public void addNamedGraph(String name) {
        if (this.namedGraphURIs == null) {
            this.namedGraphURIs = new ArrayList();
        }
        this.namedGraphURIs.add(name);
    }

    public ResultSet execSelect() {
        HttpQuery httpQuery = this.makeHttpQuery();
        httpQuery.setAccept("application/sparql-results+xml");
        InputStream in = httpQuery.exec();
        ResultSet rs = ResultSetFactory.fromXML(in);
        return rs;
    }

    public Model execConstruct() {
        return this.execModel();
    }

    public Model execDescribe() {
        return this.execModel();
    }

    private Model execModel() {
        HttpQuery httpQuery = this.makeHttpQuery();
        httpQuery.setAccept("application/rdf+xml");
        InputStream in = httpQuery.exec();
        Model m = ModelFactory.createDefaultModel();
        m.read(in, null);
        return m;
    }

    public boolean execAsk() {
        HttpQuery httpQuery = this.makeHttpQuery();
        httpQuery.setAccept("application/sparql-results+xml");
        InputStream in = httpQuery.exec();
        XMLInputStAX x = new XMLInputStAX(in);
        return x.getBooleanResult();
    }

    public Context getContext() {
        return this.parameters;
    }

    private HttpQuery makeHttpQuery() {
        HttpQuery httpQuery = new HttpQuery(this.service);
        httpQuery.addParam("query", this.queryString);
        Iterator iter = this.defaultGraphURIs.iterator();
        while (iter.hasNext()) {
            String dft = (String)iter.next();
            httpQuery.addParam("default-graph-uri", dft);
        }
        iter = this.namedGraphURIs.iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            httpQuery.addParam("named-graph-uri", name);
        }
        return httpQuery;
    }

    public void abort() {
    }

    public void close() {
    }

    public String toString() {
        HttpQuery httpQuery = this.makeHttpQuery();
        return "GET " + httpQuery.toString();
    }
}

