/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.query.expr;

import java.util.List;
import mx.com.hp.hpl.jena.query.core.Binding;
import mx.com.hp.hpl.jena.query.engine1.ExecutionContext;
import mx.com.hp.hpl.jena.query.expr.Expr;
import mx.com.hp.hpl.jena.query.expr.ExprEvalException;
import mx.com.hp.hpl.jena.query.expr.ExprNodeFunction;
import mx.com.hp.hpl.jena.query.expr.NodeValue;
import mx.com.hp.hpl.jena.query.function.Function;
import mx.com.hp.hpl.jena.query.function.FunctionFactory;
import mx.com.hp.hpl.jena.query.function.FunctionRegistry;
import mx.com.hp.hpl.jena.query.serializer.SerializationContext;
import mx.com.hp.hpl.jena.query.util.FmtUtils;

public class E_Function
extends ExprNodeFunction {
    private static final String symbol = "function";
    List args = null;
    String name = null;
    Function function = null;
    boolean functionBound = false;

    public E_Function(String name, List args) {
        super(symbol);
        this.name = name;
        this.args = args;
    }

    private void bindFunction() {
        if (this.functionBound) {
            return;
        }
        FunctionFactory ff = FunctionRegistry.get().get(this.name);
        if (ff == null) {
            throw new ExprEvalException("URI '" + this.name + "' not found as a function");
        }
        this.function = ff.create(this.name);
        this.functionBound = true;
    }

    public NodeValue eval(Binding binding, ExecutionContext execCxt) {
        this.bindFunction();
        NodeValue r = this.function.exec(binding, this.args, this.name, execCxt.getDataset(), execCxt);
        return r;
    }

    public void check() {
    }

    public Expr getArg(int i) {
        if (this.args.size() <= --i) {
            return null;
        }
        return (Expr)this.args.get(i);
    }

    public int numArgs() {
        return this.args.size();
    }

    public String getPrintName(SerializationContext cxt) {
        return FmtUtils.stringForURI(this.name, cxt);
    }
}

