/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.query.expr;

import mx.com.hp.hpl.jena.query.core.Binding;
import mx.com.hp.hpl.jena.query.engine1.ExecutionContext;
import mx.com.hp.hpl.jena.query.expr.Expr;
import mx.com.hp.hpl.jena.query.expr.ExprEvalException;
import mx.com.hp.hpl.jena.query.expr.ExprNodeBoolean2;
import mx.com.hp.hpl.jena.query.expr.NodeValue;

public class E_LogicalOr
extends ExprNodeBoolean2 {
    private static final String printName = "or";
    private static final String symbol = "||";

    public E_LogicalOr(Expr left, Expr right) {
        super(left, right, symbol, printName);
    }

    public NodeValue eval(Binding binding, ExecutionContext execCxt) {
        ExprEvalException error = null;
        try {
            NodeValue x = this.left.eval(binding, execCxt);
            if (!x.isBoolean()) {
                throw new ExprEvalException("E_LogicalOr: Wanted a boolean: " + x);
            }
            if (x.getBoolean()) {
                return NodeValue.TRUE;
            }
        }
        catch (ExprEvalException eee) {
            error = eee;
        }
        try {
            NodeValue y = this.right.eval(binding, execCxt);
            if (!y.isBoolean()) {
                throw new ExprEvalException("E_LogicalOr: Wanted a boolean: " + y);
            }
            if (y.getBoolean()) {
                return NodeValue.TRUE;
            }
            if (error != null) {
                throw error;
            }
            return NodeValue.FALSE;
        }
        catch (ExprEvalException eee) {
            if (error != null) {
                throw error;
            }
            throw eee;
        }
    }
}

