/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.query.expr;

import mx.com.hp.hpl.jena.query.core.Binding;
import mx.com.hp.hpl.jena.query.engine1.ExecutionContext;
import mx.com.hp.hpl.jena.query.expr.Expr;
import mx.com.hp.hpl.jena.query.expr.ExprEvalException;
import mx.com.hp.hpl.jena.query.expr.ExprNodeNumeric2;
import mx.com.hp.hpl.jena.query.expr.NodeValue;

public class E_Multiply
extends ExprNodeNumeric2 {
    private static final String printName = "mul";
    private static final String symbol = "*";

    public E_Multiply(Expr left, Expr right) {
        super(left, right, symbol, printName);
    }

    public NodeValue eval(Binding binding, ExecutionContext execCxt) {
        NodeValue x = this.left.eval(binding, execCxt);
        NodeValue y = this.right.eval(binding, execCxt);
        if (!x.isNumber()) {
            throw new ExprEvalException("E_Multiply: Wanted a number: " + x);
        }
        if (!y.isNumber()) {
            throw new ExprEvalException("E_Multiply: Wanted a number: " + y);
        }
        if (x.isInteger() && y.isInteger()) {
            return NodeValue.makeInteger(x.getInteger() * y.getInteger());
        }
        return NodeValue.makeDouble(x.getDouble() * y.getDouble());
    }
}

