/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.query.expr;

import mx.com.hp.hpl.jena.query.core.Binding;
import mx.com.hp.hpl.jena.query.engine1.ExecutionContext;
import mx.com.hp.hpl.jena.query.expr.Expr;
import mx.com.hp.hpl.jena.query.expr.ExprEvalException;
import mx.com.hp.hpl.jena.query.expr.ExprException;
import mx.com.hp.hpl.jena.query.expr.ExprNodeFunction;
import mx.com.hp.hpl.jena.query.expr.NodeValue;
import org.apache.oro.text.regex.MalformedPatternException;
import org.apache.oro.text.regex.Pattern;
import org.apache.oro.text.regex.PatternCompiler;
import org.apache.oro.text.regex.PatternMatcher;
import org.apache.oro.text.regex.Perl5Compiler;
import org.apache.oro.text.regex.Perl5Matcher;

public class E_Regex
extends ExprNodeFunction {
    private static final String name = "regex";
    Expr expr;
    Expr pattern;
    Expr flags;
    boolean constantRegex = false;
    Regex regex = null;
    PatternCompiler compiler = new Perl5Compiler();
    PatternMatcher matcher = new Perl5Matcher();

    public E_Regex(Expr _expr, Expr _pattern, Expr _flags) {
        super(name);
        this.expr = _expr;
        this.pattern = _pattern;
        this.flags = _flags;
        if (!(this.pattern instanceof NodeValue)) {
            return;
        }
        if (this.flags != null && !(this.flags instanceof NodeValue)) {
            return;
        }
        NodeValue nvPattern = (NodeValue)this.pattern;
        if (!nvPattern.isString()) {
            throw new ExprException("Pattern is not a string: " + this);
        }
        String p = ((NodeValue)this.pattern).getString();
        String f = null;
        if (this.flags != null) {
            if (!(this.flags instanceof NodeValue)) {
                return;
            }
            NodeValue nvFlags = (NodeValue)this.flags;
            if (!nvFlags.isString()) {
                throw new ExprException("Flags are not a string: " + this);
            }
            f = nvFlags.getString();
        }
        this.constantRegex = true;
        try {
            this.regex = new Regex(p, f);
        }
        catch (MalformedPatternException pEx) {
            throw new ExprException("Regex: Pattern exception: " + (Object)((Object)pEx));
        }
    }

    public E_Regex(Expr _expr, String _pattern, String _flags) {
        super(name);
        this.expr = _expr;
        this.pattern = NodeValue.makeNodeString(_pattern);
        this.flags = _flags != null ? NodeValue.makeNodeString(_flags) : null;
        try {
            this.regex = new Regex(_pattern, _flags);
            this.constantRegex = true;
        }
        catch (MalformedPatternException pEx) {
            throw new ExprException("Regex: Pattern exception: " + (Object)((Object)pEx));
        }
    }

    public NodeValue eval(Binding binding, ExecutionContext execCxt) {
        boolean b;
        NodeValue v = this.expr.eval(binding, execCxt);
        if (!v.isString()) {
            throw new ExprEvalException("REGEX: " + this.expr + " evaluates to " + v + ", which is not a string");
        }
        Regex thisRegex = this.regex;
        if (thisRegex == null) {
            NodeValue vPattern = this.pattern.eval(binding, execCxt);
            NodeValue vFlags = null;
            if (this.flags != null) {
                vFlags = this.flags.eval(binding, execCxt);
            }
            if (!vPattern.isString()) {
                throw new ExprEvalException("REGEX: Pattern is not a string: " + vPattern);
            }
            if (vFlags != null && !vFlags.isString()) {
                throw new ExprEvalException("REGEX: Pattern flags are not a string: " + vFlags);
            }
            String s = vFlags == null ? null : vFlags.getString();
            try {
                thisRegex = new Regex(vPattern.getString(), s);
            }
            catch (MalformedPatternException pEx) {
                throw new ExprEvalException("Regex: Pattern exception: " + (Object)((Object)pEx));
            }
        }
        return (b = thisRegex.match(v.getString())) ? NodeValue.TRUE : NodeValue.FALSE;
    }

    public void check() {
    }

    private int makeMask(String modifiers) {
        if (modifiers == null) {
            return 0;
        }
        int newMask = 0;
        block6: for (int i = 0; i < modifiers.length(); ++i) {
            switch (modifiers.charAt(i)) {
                case 'i': {
                    newMask |= 1;
                    continue block6;
                }
                case 'm': {
                    newMask |= 8;
                    continue block6;
                }
                case 's': {
                    newMask |= 0x10;
                    continue block6;
                }
                case 'x': {
                    newMask |= 0x20;
                    continue block6;
                }
                default: {
                    throw new ExprEvalException("Illegal flag in regex modifiers: " + modifiers.charAt(i));
                }
            }
        }
        return newMask;
    }

    public Expr getArg(int i) {
        if (i == 1) {
            return this.expr;
        }
        if (i == 2) {
            return this.pattern;
        }
        if (i == 3 && this.flags != null) {
            return this.flags;
        }
        return null;
    }

    public int numArgs() {
        if (this.flags != null) {
            return 3;
        }
        return 2;
    }

    public Expr getExpr() {
        return this.expr;
    }

    public Expr getFlags() {
        return this.flags;
    }

    public Expr getPattern() {
        return this.pattern;
    }

    private class Regex {
        Pattern regexPattern;

        Regex(String patternStr, String flags) throws MalformedPatternException {
            int mask = 0;
            if (flags != null) {
                mask = E_Regex.this.makeMask(flags);
            }
            this.regexPattern = E_Regex.this.compiler.compile(patternStr, mask);
        }

        boolean match(String s) {
            return E_Regex.this.matcher.contains(s, this.regexPattern);
        }
    }
}

