/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.query.expr;

import mx.com.hp.hpl.jena.query.expr.ExprEvalException;

public class NodePatternLiteral {
    String pattern = null;
    int mask = -1;
    String modifiers;

    public NodePatternLiteral(String _pattern) {
        this(_pattern, "");
    }

    public NodePatternLiteral(String _pattern, String _modifiers) {
        this.pattern = _pattern;
        this.modifiers = _modifiers;
        this.mask = this.makeMask(this.modifiers);
    }

    public int makeMask(String _modifiers) {
        int newMask = 0;
        block6: for (int i = 0; i < this.modifiers.length(); ++i) {
            switch (this.modifiers.charAt(i)) {
                case 'i': {
                    newMask |= 1;
                    continue block6;
                }
                case 'm': {
                    newMask |= 8;
                    continue block6;
                }
                case 's': {
                    newMask |= 0x10;
                    continue block6;
                }
                case 'x': {
                    newMask |= 0x20;
                    continue block6;
                }
                default: {
                    throw new ExprEvalException("Illegal flag in regex modifiers: " + this.modifiers.charAt(i));
                }
            }
        }
        return newMask;
    }

    public String getPattern() {
        return this.pattern;
    }

    public int getMask() {
        return this.mask;
    }

    public String toString() {
        if (this.pattern.indexOf(47) == -1) {
            return "/" + this.pattern + "/" + this.modifiers;
        }
        if (this.pattern.indexOf(33) == -1) {
            return "m!" + this.pattern + "!" + this.modifiers;
        }
        if (this.pattern.indexOf(37) == -1) {
            return "m%" + this.pattern + "%" + this.modifiers;
        }
        char marker = '!';
        return "m" + marker + this.quote(this.pattern, marker) + marker + this.pattern;
    }

    private String quote(String pString, char marker) {
        int j;
        int i = 0;
        while ((j = pString.indexOf(marker, i)) != -1) {
            pString = pString.substring(0, j) + "\\" + pString.substring(j);
            i = j + 2;
        }
        return pString;
    }

    public int hashCode() {
        int x = this.pattern.hashCode();
        if (this.modifiers != null) {
            x ^= this.modifiers.hashCode();
        }
        return x;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof NodePatternLiteral)) {
            return false;
        }
        NodePatternLiteral p = (NodePatternLiteral)other;
        if (!this.pattern.equals(p.pattern)) {
            return false;
        }
        return (this.modifiers != null || p.modifiers != null) && this.modifiers.equals(p.modifiers);
    }
}

