/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.query.expr;

import java.util.Calendar;
import mx.com.hp.hpl.jena.datatypes.DatatypeFormatException;
import mx.com.hp.hpl.jena.datatypes.RDFDatatype;
import mx.com.hp.hpl.jena.datatypes.TypeMapper;
import mx.com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import mx.com.hp.hpl.jena.datatypes.xsd.XSDDateTime;
import mx.com.hp.hpl.jena.graph.Node;
import mx.com.hp.hpl.jena.graph.impl.LiteralLabel;
import mx.com.hp.hpl.jena.query.core.ARQInternalErrorException;
import mx.com.hp.hpl.jena.query.core.Binding;
import mx.com.hp.hpl.jena.query.engine1.EngineConfig;
import mx.com.hp.hpl.jena.query.engine1.ExecutionContext;
import mx.com.hp.hpl.jena.query.expr.ExprEvalException;
import mx.com.hp.hpl.jena.query.expr.ExprException;
import mx.com.hp.hpl.jena.query.expr.ExprNode;
import mx.com.hp.hpl.jena.query.expr.ExprTypeException;
import mx.com.hp.hpl.jena.query.expr.ExprVisitor;
import mx.com.hp.hpl.jena.query.serializer.SerializationContext;
import mx.com.hp.hpl.jena.query.util.FmtUtils;
import mx.com.hp.hpl.jena.query.util.NodeUtils;
import mx.com.hp.hpl.jena.query.util.Utils;
import mx.com.hp.hpl.jena.shared.PrefixMapping;
import mx.com.hp.hpl.jena.shared.impl.JenaParameters;
import mx.com.hp.hpl.jena.vocabulary.XSD;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class NodeValue
extends ExprNode {
    private static Log log = LogFactory.getLog((Class)NodeValue.class);
    public static boolean VerboseWarnings = true;
    public static boolean VerboseExceptions = false;
    public static final NodeValue TRUE = NodeValue.makeNode("true", XSDDatatype.XSDboolean);
    public static final NodeValue FALSE = NodeValue.makeNode("false", XSDDatatype.XSDboolean);
    public static final int CMP_GREATER = 1;
    public static final int CMP_EQUAL = 0;
    public static final int CMP_LESS = -1;
    public static final int CMP_UNKNOWN = -15;
    protected boolean isSet = false;
    private boolean isInteger = false;
    private boolean isDouble = false;
    private boolean isBoolean = false;
    private boolean isString = false;
    private boolean isGraphNode = false;
    private boolean isDate = false;
    private Calendar valDate;
    private long valInteger;
    private boolean valBoolean;
    private double valDouble;
    private String valString;
    private Node valGraphNode;
    private static boolean doBooleanEffectiveValue = EngineConfig.getContext().isTrueOrUndef(EngineConfig.effectiveBooleanValue);
    private static boolean doStringToNumberPromotion = false;
    private static final boolean dynamicNumberConversion = false;
    private static final boolean sameValueAsString = JenaParameters.enablePlainLiteralSameAsString;
    private static final int CLASS_UNDEF = -5;
    private static final int CLASS_NUM = 10;
    private static final int CLASS_DT = 11;
    private static final int CLASS_STRING = 12;
    private static final int CLASS_BOOLEAN = 13;
    private static final int CLASS_NODE = 14;

    NodeValue() {
    }

    protected NodeValue(NodeValue v) {
        if (v.isNode()) {
            this._setNode(v.getNode());
        }
        if (v.isBoolean()) {
            this._setBoolean(v.getBoolean());
        }
        if (v.isInteger()) {
            this._setInteger(v.getInteger());
        }
        if (v.isDouble()) {
            this._setDouble(v.getDouble());
        }
        if (v.isString()) {
            this._setString(v.getString());
        }
        if (v.isDate()) {
            this._setDate(v.getDate());
        }
        log.warn((Object)("Unknown NodeValue in constructor: " + v));
    }

    public boolean isConstant() {
        return true;
    }

    public NodeValue getConstant() {
        return this;
    }

    public static NodeValue makeInteger(long i) {
        NodeValue nv = new NodeValue();
        nv._setInteger(i);
        return nv;
    }

    public static NodeValue makeInteger(String s) {
        NodeValue nv = NodeValue.makeString(s);
        nv.forceInteger(true);
        return nv;
    }

    public static NodeValue makeDouble(double d) {
        NodeValue nv = new NodeValue();
        nv._setDouble(d);
        return nv;
    }

    public static NodeValue makeDouble(String s) {
        NodeValue nv = NodeValue.makeString(s);
        nv.forceDouble(true);
        return nv;
    }

    public static NodeValue makeBoolean(boolean b) {
        NodeValue nv = new NodeValue();
        nv._setBoolean(b);
        return nv;
    }

    public static NodeValue booleanReturn(boolean b) {
        return b ? TRUE : FALSE;
    }

    public static NodeValue makeString(String s) {
        NodeValue nv = new NodeValue();
        nv._setString(s);
        return nv;
    }

    public static NodeValue makeNode(Node n) {
        NodeValue nv = new NodeValue();
        nv._setNode(n);
        return nv;
    }

    public static NodeValue makeNode(String lexicalForm, XSDDatatype dtype) {
        Node n = Node.createLiteral((String)lexicalForm, null, (RDFDatatype)dtype);
        NodeValue nv = NodeValue.makeNode(n);
        return nv;
    }

    public static NodeValue makeNode(String lexicalForm, String langTag, Node datatype) {
        String uri = datatype == null ? null : datatype.getURI();
        return NodeValue.makeNode(lexicalForm, langTag, uri);
    }

    public static NodeValue makeNode(String lexicalForm, String langTag, String datatype) {
        if (datatype != null && datatype.equals("")) {
            datatype = null;
        }
        Node n = null;
        if (datatype != null) {
            RDFDatatype dType = TypeMapper.getInstance().getSafeTypeByName(datatype);
            n = Node.createLiteral((String)lexicalForm, null, (RDFDatatype)dType);
        } else {
            n = Node.createLiteral((String)lexicalForm, (String)langTag, null);
        }
        return NodeValue.makeNode(n);
    }

    public static NodeValue makeNodeBoolean(boolean b) {
        return b ? TRUE : FALSE;
    }

    public static NodeValue makeNodeInteger(long v) {
        NodeValue nv = NodeValue.makeNode(Long.toString(v), null, XSD.integer.getURI());
        return nv;
    }

    public static NodeValue makeNodeInteger(String lexicalForm) {
        NodeValue nv = NodeValue.makeNode(lexicalForm, null, XSD.integer.getURI());
        return nv;
    }

    public static NodeValue makeNodeDouble(double v) {
        NodeValue nv = NodeValue.makeNode(Double.toString(v), null, XSD.xdouble.getURI());
        return nv;
    }

    public static NodeValue makeNodeDouble(String lexicalForm) {
        NodeValue nv = NodeValue.makeNode(lexicalForm, null, XSD.xdouble.getURI());
        return nv;
    }

    public static NodeValue makeNodeString(String string) {
        NodeValue nv = NodeValue.makeNode(string, null, (String)null);
        return nv;
    }

    public static NodeValue makeNodeDate(Calendar date2) {
        String lex = Utils.calendarToXSDDateTimeString(date2);
        NodeValue nv = NodeValue.makeNode(lex, XSDDatatype.XSDdateTime);
        return nv;
    }

    protected void unset() {
        this.isSet = false;
        this.valString = null;
        this.valGraphNode = null;
        this.valInteger = 0L;
        this.valBoolean = false;
        this.valDouble = 0.0;
        this.valGraphNode = null;
        this.isInteger = false;
        this.isBoolean = false;
        this.isDouble = false;
        this.isString = false;
    }

    public NodeValue eval(Binding binding, ExecutionContext execCxt) {
        if (!this.isSet) {
            NodeValue.raise(new ExprTypeException("Literal value not set"));
        }
        return this;
    }

    public static boolean sameValueAs(NodeValue nv1, NodeValue nv2) {
        int compType = NodeValue.classifyOP(nv1, nv2);
        switch (compType) {
            case 10: {
                return NodeValue.compareAsNum(nv1, nv2) == 0;
            }
            case 11: {
                return NodeValue.compareAsDates(nv1, nv2) == 0;
            }
            case 12: {
                return NodeValue.compareAsString(nv1, nv2) == 0;
            }
            case 13: {
                return nv1.valBoolean == nv2.valBoolean;
            }
            case 14: {
                return nv1.valGraphNode.equals((Object)nv2.valGraphNode);
            }
        }
        NodeValue.raise(new ExprEvalException("Can't sameValueAs " + nv1 + " and " + nv2));
        return false;
    }

    public static boolean notSameValueAs(NodeValue nv1, NodeValue nv2) {
        int compType = NodeValue.classifyOP(nv1, nv2);
        switch (compType) {
            case 10: {
                return NodeValue.compareAsNum(nv1, nv2) != 0;
            }
            case 11: {
                return NodeValue.compareAsDates(nv1, nv2) != 0;
            }
            case 12: {
                return NodeValue.compareAsString(nv1, nv2) != 0;
            }
            case 13: {
                return nv1.valBoolean != nv2.valBoolean;
            }
            case 14: {
                String lang2;
                Node n1 = nv1.valGraphNode;
                Node n2 = nv2.valGraphNode;
                if (!n1.isLiteral() || !n2.isLiteral()) {
                    return !nv1.valGraphNode.equals((Object)nv2.valGraphNode);
                }
                String dt1 = n1.getLiteralDatatypeURI();
                String dt2 = n2.getLiteralDatatypeURI();
                if (sameValueAsString) {
                    if (dt1 != null && dt1.equals(XSDDatatype.XSDstring.getURI())) {
                        dt1 = null;
                    }
                    if (dt2 != null && dt2.equals(XSDDatatype.XSDstring.getURI())) {
                        dt2 = null;
                    }
                }
                String lex1 = n1.getLiteralLexicalForm();
                String lex2 = n2.getLiteralLexicalForm();
                String lang1 = n1.getLiteralLanguage();
                if (lang1 == null) {
                    lang1 = "";
                }
                if ((lang2 = n2.getLiteralLanguage()) == null) {
                    lang2 = "";
                }
                if (dt1 == null && dt2 == null) {
                    if (lang1.equals("") && lang2.equals("")) {
                        log.warn((Object)"Internal error: Should be string comparisons, not unknown literals types");
                        return !lex1.equals(lex2);
                    }
                    if (!lang1.equals(lang2)) {
                        return true;
                    }
                    return !lex1.equals(lex2);
                }
                if (dt1 == null && dt2 != null) {
                    return true;
                }
                if (dt2 == null && dt1 != null) {
                    return true;
                }
                if (!dt1.equals(dt2)) {
                    return false;
                }
                return false;
            }
        }
        return false;
    }

    public static int compareAlways(NodeValue nv1, NodeValue nv2) {
        int x = NodeValue.compare(nv1, nv2);
        if (x != -15) {
            return x;
        }
        if (nv1.isNode() && nv2.isNode()) {
            return NodeUtils.compareNodesByKindTypeLexical(nv1.getNode(), nv2.getNode());
        }
        return -15;
    }

    public static int compare(NodeValue nv1, NodeValue nv2) {
        return NodeValue.compare(nv1, nv2, false);
    }

    private static int compare(NodeValue nv1, NodeValue nv2, boolean generalCompare) {
        if (nv1 == null && nv2 == null) {
            return 0;
        }
        if (nv1 == null) {
            return -1;
        }
        if (nv2 == null) {
            return 1;
        }
        int compType = NodeValue.classifyOP(nv1, nv2);
        if (compType == 13 && !generalCompare) {
            compType = -5;
        }
        switch (compType) {
            case 10: {
                return NodeValue.compareAsNum(nv1, nv2);
            }
            case 11: {
                return NodeValue.compareAsDates(nv1, nv2);
            }
            case 12: {
                return NodeValue.compareAsString(nv1, nv2);
            }
            case 13: {
                return NodeValue.compareAsBooleans(nv1, nv2);
            }
        }
        NodeValue.raise(new ExprEvalException("Can't compare " + nv1 + " and " + nv2));
        return -15;
    }

    private static int classifyOP(NodeValue nv1, NodeValue nv2) {
        if (!nv1.isSet || !nv2.isSet) {
            return -5;
        }
        nv1.forceNumber();
        nv2.forceNumber();
        if (nv1.isNumber()) {
            if (nv2.isNumber()) {
                return 10;
            }
            return -5;
        }
        if (nv2.isNumber()) {
            return -5;
        }
        if (nv1.isDate() && nv2.isDate()) {
            return 11;
        }
        if (nv1.isString() && nv2.isString()) {
            return 12;
        }
        if (nv1.isBoolean() && nv2.isBoolean()) {
            return 13;
        }
        if (nv1.isNode() && nv2.isNode()) {
            return 14;
        }
        return -5;
    }

    private static int compareAsNum(NodeValue nv1, NodeValue nv2) {
        if (nv1.isInteger && nv2.isInteger) {
            if (nv1.valInteger < nv2.valInteger) {
                return -1;
            }
            if (nv1.valInteger > nv2.valInteger) {
                return 1;
            }
            return 0;
        }
        nv1.forceDouble(true);
        nv2.forceDouble(true);
        if (!nv1.isDouble || !nv2.isDouble) {
            NodeValue.raise(new ExprEvalException("Can't force to doubles"));
        }
        return Double.compare(nv1.valDouble, nv2.valDouble);
    }

    private static int compareAsDates(NodeValue nv1, NodeValue nv2) {
        if (nv1.valDate.after(nv2.valDate)) {
            return 1;
        }
        if (nv1.valDate.before(nv2.valDate)) {
            return -1;
        }
        return 0;
    }

    private static int compareAsString(NodeValue nv1, NodeValue nv2) {
        return nv1.valString.compareTo(nv2.valString);
    }

    private static int compareAsBooleans(NodeValue nv1, NodeValue nv2) {
        boolean b1 = nv1.valBoolean;
        boolean b2 = nv2.valBoolean;
        if (b1 == b2) {
            return 0;
        }
        if (!b1 && b2) {
            return -1;
        }
        if (b1 && !b2) {
            return 1;
        }
        return -15;
    }

    public boolean isSet() {
        return this.isSet;
    }

    public static Node toNode(NodeValue nv) {
        if (nv == null) {
            return null;
        }
        return nv.asNode();
    }

    public Node asNode() {
        this.forceNode();
        return this.valGraphNode;
    }

    public Node getNode() {
        if (!this.isSet) {
            NodeValue.raise(new ExprEvalException("Not set: " + this));
        }
        if (!this.isGraphNode) {
            NodeValue.raise(new ExprEvalException("Not a graph node: " + this));
        }
        return this.valGraphNode;
    }

    public String getString() {
        if (!this.isSet || !this.isString) {
            NodeValue.raise(new ExprEvalException("Not a string: " + this));
        }
        return this.valString;
    }

    public boolean getBoolean() {
        if (doBooleanEffectiveValue) {
            return this.getBooleanBEV();
        }
        return this.getBooleanRaw();
    }

    public boolean getBooleanRaw() {
        if (!this.isSet || !this.isBoolean) {
            NodeValue.raise(new ExprEvalException("Not a boolean: " + this));
        }
        return this.valBoolean;
    }

    public boolean getBooleanBEV() {
        if (!this.isSet) {
            NodeValue.raise(new ExprEvalException("Not a boolean effective value (unset): " + this));
        }
        if (this.isBooleanRaw()) {
            return this.getBooleanRaw();
        }
        if (this.isString()) {
            return this.getString().length() > 0;
        }
        if (this.isInteger()) {
            return this.getInteger() != 0L;
        }
        if (this.isDouble()) {
            return this.getDouble() != 0.0;
        }
        NodeValue.raise(new ExprEvalException("Not a boolean effective value (wrong type): " + this));
        return false;
    }

    public double getDouble() {
        if (!this.isSet || !this.isDouble && !this.isInteger) {
            NodeValue.raise(new ExprEvalException("Not a double: " + this));
        }
        if (this.isInteger) {
            return this.valInteger;
        }
        return this.valDouble;
    }

    public long getInteger() {
        if (!this.isSet || !this.isInteger) {
            NodeValue.raise(new ExprEvalException("Not an int: " + this));
        }
        return this.valInteger;
    }

    public Calendar getDate() {
        if (!this.isSet || !this.isDate) {
            NodeValue.raise(new ExprEvalException("Not a date: " + this));
        }
        return this.valDate;
    }

    public boolean isNumber() {
        return this.isSet && (this.isInteger || this.isDouble);
    }

    public boolean isLiteral() {
        if (this.isGraphNode) {
            return this.valGraphNode.isLiteral();
        }
        return true;
    }

    public boolean isInteger() {
        return this.isSet && this.isInteger;
    }

    public boolean isDouble() {
        return this.isSet && this.isDouble;
    }

    public boolean isBooleanRaw() {
        return this.isSet && this.isBoolean;
    }

    public boolean isBooleanBEV() {
        return this.isSet && (this.isBoolean || this.isInteger || this.isDouble || this.isString);
    }

    public boolean isBoolean() {
        if (doBooleanEffectiveValue) {
            return this.isBooleanBEV();
        }
        return this.isBooleanRaw();
    }

    public boolean isString() {
        return this.isSet && this.isString;
    }

    public boolean isNode() {
        return this.isSet && this.isGraphNode;
    }

    public boolean isDate() {
        return this.isSet && this.isDate;
    }

    protected void setInteger(long i) {
        this.unset();
        this._setInteger(i);
    }

    protected void _setInteger(long i) {
        this.isSet = true;
        this.isInteger = true;
        this.valInteger = i;
        this.isDouble = true;
        this.valDouble = i;
    }

    protected void setDouble(double d) {
        this.unset();
        this._setDouble(d);
    }

    protected void _setDouble(double d) {
        this.isSet = true;
        this.isDouble = true;
        this.valDouble = d;
    }

    protected void setBoolean(boolean b) {
        this.unset();
        this.setBoolean(b);
    }

    protected void _setBoolean(boolean b) {
        this.isSet = true;
        this.isBoolean = true;
        this.valBoolean = b;
    }

    protected void setString(String s) {
        this.unset();
        this._setString(s);
    }

    protected void _setString(String s) {
        this.isSet = true;
        this.isString = true;
        this.valString = s;
    }

    protected void setNode(Node n) {
        this.unset();
        this._setNode(n);
    }

    protected void _setNode(Node n) {
        this.isSet = true;
        this.isGraphNode = true;
        this.valGraphNode = n;
        if (n.isURI()) {
            this.valString = n.getURI();
            this.isGraphNode = true;
            return;
        }
        if (n.isBlank()) {
            this.valGraphNode = n;
            this.isGraphNode = true;
            return;
        }
        if (n.isLiteral()) {
            boolean isPlainLiteral;
            boolean hasLangTag = n.getLiteralLanguage() != null && !n.getLiteralLanguage().equals("");
            boolean bl = isPlainLiteral = n.getLiteralDatatypeURI() == null && !hasLangTag;
            if (isPlainLiteral) {
                this._setString(n.getLiteralLexicalForm());
                return;
            }
            LiteralLabel lit = n.getLiteral();
            if (hasLangTag) {
                if (n.getLiteralDatatypeURI() != null) {
                    if (VerboseWarnings) {
                        log.warn((Object)"Lang tag and datatype (datatype ignored)");
                    } else if (log.isDebugEnabled()) {
                        log.debug((Object)"Lang tag and datatype (datatype ignored)");
                    }
                }
                return;
            }
            boolean setByValue = false;
            if (!lit.getDatatype().isValidLiteral(lit)) {
                if (VerboseWarnings) {
                    String tmp = FmtUtils.stringForNode(n, PrefixMapping.Standard);
                    log.warn((Object)("Datatype format exception: " + tmp));
                } else if (log.isDebugEnabled()) {
                    String tmp = FmtUtils.stringForNode(n, PrefixMapping.Standard);
                    log.debug((Object)("Datatype format exception: " + tmp));
                }
            } else {
                setByValue = this._setByValue(n);
            }
            if (!setByValue && lit.getDatatypeURI() != null && log.isDebugEnabled()) {
                log.debug((Object)("Unrecognized literal: " + n));
            }
            return;
        }
        NodeValue.raise(new ExprException("NodeValue._setNode: Unknown Node type: " + n));
    }

    private boolean _setByValue(Node n) {
        LiteralLabel lit = n.getLiteral();
        try {
            if (sameValueAsString && XSDDatatype.XSDstring.isValidLiteral(n.getLiteral())) {
                this._setString(n.getLiteralLexicalForm());
                return true;
            }
            if (XSDDatatype.XSDinteger.isValidLiteral(lit)) {
                long i = ((Number)lit.getValue()).longValue();
                this._setInteger(i);
                return true;
            }
            if (XSDDatatype.XSDdouble.isValidLiteral(lit)) {
                double d = ((Number)lit.getValue()).doubleValue();
                this._setDouble(d);
                return true;
            }
            if (XSDDatatype.XSDfloat.isValidLiteral(lit)) {
                double d = ((Number)lit.getValue()).floatValue();
                this._setDouble(d);
                return true;
            }
            if (XSDDatatype.XSDdateTime.isValidLiteral(lit)) {
                XSDDateTime dateTime = (XSDDateTime)lit.getValue();
                this._setDate(dateTime.asCalendar());
                return true;
            }
            if (XSDDatatype.XSDboolean.isValidLiteral(lit)) {
                boolean b = (Boolean)lit.getValue();
                this._setBoolean(b);
                return true;
            }
        }
        catch (DatatypeFormatException ex) {
            throw new ARQInternalErrorException("DatatypeFormatException: " + lit, ex);
        }
        return false;
    }

    protected void setDate(Calendar cal) {
        this.unset();
        this._setDate(cal);
    }

    protected void _setDate(Calendar cal) {
        this.isSet = true;
        this.isDate = true;
        this.valDate = cal;
    }

    private void forceInteger(boolean raiseException) {
        if (!this.isSet || this.isInteger) {
            return;
        }
        if (this.isDouble) {
            return;
        }
        if (!doStringToNumberPromotion) {
            return;
        }
        if (!this.isString) {
            return;
        }
        try {
            String s = this.valString;
            if (s.startsWith("+")) {
                s = s.substring(1);
            }
            long val = Long.parseLong(s);
            this._setInteger(val);
        }
        catch (NumberFormatException e2) {
            if (raiseException) {
                NodeValue.raise(new ExprException("Number format exception:" + this, e2));
            }
            return;
        }
    }

    private void forceDouble(boolean raiseException) {
        if (!this.isSet || this.isDouble) {
            return;
        }
        if (this.isInteger) {
            this.valDouble = this.valInteger;
            this.isDouble = true;
            return;
        }
        if (!doStringToNumberPromotion) {
            return;
        }
        if (!this.isString) {
            return;
        }
        try {
            double val = Double.parseDouble(this.valString);
            this._setDouble(val);
        }
        catch (NumberFormatException e2) {
            if (raiseException) {
                NodeValue.raise(new ExprException("Number format exception:" + this, e2));
            }
            return;
        }
    }

    private void forceNumber() {
        if (!this.isSet) {
            return;
        }
        if (this.isInteger || this.isDouble || !this.isString) {
            return;
        }
        this.forceInteger(false);
        if (!this.isInteger) {
            this.forceDouble(false);
        }
    }

    private void forceNode() {
        if (this.isNode()) {
            return;
        }
        Node n = null;
        if (this.isBooleanRaw()) {
            n = Node.createLiteral((String)(this.getBoolean() ? "true" : "false"), null, (RDFDatatype)XSDDatatype.XSDboolean);
        }
        if (this.isDate()) {
            n = Node.createLiteral((String)Utils.calendarToXSDDateTimeString(this.valDate), null, (RDFDatatype)XSDDatatype.XSDdateTime);
        }
        if (this.isInteger()) {
            n = Node.createLiteral((String)Long.toString(this.valInteger), null, (RDFDatatype)XSDDatatype.XSDinteger);
        }
        if (this.isDouble()) {
            n = Node.createLiteral((String)Double.toString(this.valDouble), null, (RDFDatatype)XSDDatatype.XSDdouble);
        }
        if (this.isString()) {
            n = Node.createLiteral((String)this.valString);
        }
        if (n == null) {
            NodeValue.raise(new ExprException("forceNode: Unrecognized NodeValue: " + this));
        }
        this.valGraphNode = n;
        this.isGraphNode = true;
    }

    private static void raise(ExprException ex) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Exception: " + ex.getMessage()));
        }
        throw ex;
    }

    public void visit(ExprVisitor visitor) {
        visitor.visit(this);
    }

    public String asQuotedString() {
        return this.asQuotedString(null);
    }

    public String asQuotedString(SerializationContext context) {
        if (!this.isSet) {
            return "literal:unset";
        }
        if (this.isGraphNode) {
            return FmtUtils.stringForNode(this.valGraphNode, context);
        }
        if (this.isInteger) {
            return Long.toString(this.valInteger);
        }
        if (this.isDouble) {
            return Double.toString(this.valDouble);
        }
        if (this.isBoolean) {
            return this.valBoolean ? "true" : "false";
        }
        if (this.isDate) {
            return NodeValue.makeNodeDate(this.valDate).asQuotedString();
        }
        if (this.isString) {
            StringBuffer sbuff = new StringBuffer();
            sbuff.append("\"");
            FmtUtils.stringEsc(sbuff, this.valString, true);
            sbuff.append("\"");
            return sbuff.toString();
        }
        return "literal:unknown";
    }

    public String asUnquotedString() {
        if (!this.isSet) {
            return "literal:unset";
        }
        if (this.isInteger) {
            return Long.toString(this.valInteger);
        }
        if (this.isDouble) {
            return Double.toString(this.valDouble);
        }
        if (this.isBoolean) {
            return this.valBoolean ? "true" : "false";
        }
        if (this.isString) {
            return this.valString;
        }
        if (this.isGraphNode) {
            return this.valGraphNode.toString();
        }
        if (this.isDate) {
            return NodeValue.makeNodeDate(this.valDate).asUnquotedString();
        }
        return "literal:unknown";
    }

    public String asString() {
        if (this.isString) {
            return this.valString;
        }
        if (this.isGraphNode && this.valGraphNode.isURI()) {
            return this.valGraphNode.getURI();
        }
        if (this.isGraphNode && this.valGraphNode.isBlank()) {
            return "";
        }
        if (this.isGraphNode && this.valGraphNode.isLiteral()) {
            String s = this.valGraphNode.getLiteral().getLexicalForm();
            return s;
        }
        if (this.isInteger) {
            return Long.toString(this.valInteger);
        }
        if (this.isDouble) {
            return Double.toString(this.valDouble);
        }
        NodeValue.raise(new ExprTypeException("Can't be turned into a string: " + this));
        return "asString";
    }

    public int hashCode() {
        return this.asNode().hashCode();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof NodeValue)) {
            return false;
        }
        NodeValue nv = (NodeValue)other;
        if (!this.isSet && !nv.isSet) {
            return true;
        }
        if (this.isInteger && nv.isInteger) {
            return this.valInteger == nv.valInteger;
        }
        if (this.isBoolean && nv.isBoolean) {
            return this.valBoolean == nv.valBoolean;
        }
        if (this.isDouble && nv.isDouble) {
            return this.valDouble == nv.valDouble;
        }
        if (this.isDate && nv.isDate) {
            return this.valDate.equals(nv.valDate);
        }
        if (this.isString && nv.isString) {
            return this.valString.equals(nv.valString);
        }
        if (this.isGraphNode && nv.isGraphNode) {
            return this.valGraphNode.equals((Object)nv.valGraphNode);
        }
        return false;
    }

    public String toString() {
        return this.asQuotedString();
    }
}

