/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.query.extension;

import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import mx.com.hp.hpl.jena.query.core.Binding;
import mx.com.hp.hpl.jena.query.engine.QueryIterator;
import mx.com.hp.hpl.jena.query.engine1.ExecutionContext;
import mx.com.hp.hpl.jena.query.extension.Extension;
import mx.com.hp.hpl.jena.query.util.Utils;

public abstract class ExtensionBaseUneval
implements Extension {
    String uri = null;
    List args;
    private ExecutionContext execCxt;

    public QueryIterator exec(QueryIterator input, List args, String uri, ExecutionContext execCxt) {
        this.uri = uri;
        this.args = args;
        this.execCxt = execCxt;
        return new RepeatApplyIterator(input);
    }

    public abstract QueryIterator execUnevaluated(List var1, Binding var2, ExecutionContext var3);

    public ExecutionContext getContext() {
        return this.execCxt;
    }

    class RepeatApplyIterator
    implements QueryIterator {
        boolean finished = false;
        int count = 0;
        QueryIterator currentStage = null;
        QueryIterator input;
        boolean inGroup = true;

        public RepeatApplyIterator(QueryIterator input) {
            this.input = input;
        }

        public boolean hasNext() {
            if (this.finished) {
                return false;
            }
            while (true) {
                if (this.currentStage == null) {
                    this.currentStage = this.makeNextStage();
                }
                if (this.currentStage == null) {
                    return false;
                }
                if (this.currentStage.hasNext()) {
                    return true;
                }
                this.currentStage.close();
                this.currentStage = null;
            }
        }

        public Object next() {
            return this.nextBinding();
        }

        public Binding nextBinding() {
            if (!this.hasNext()) {
                throw new NoSuchElementException(Utils.className(this) + ".next()/finished");
            }
            return this.currentStage.nextBinding();
        }

        private QueryIterator makeNextStage() {
            if (this.input == null) {
                return null;
            }
            if (!this.input.hasNext()) {
                this.input.close();
                this.input = null;
                return null;
            }
            Binding binding = this.input.nextBinding();
            QueryIterator iter = ExtensionBaseUneval.this.execUnevaluated(ExtensionBaseUneval.this.args, binding, ExtensionBaseUneval.this.getContext());
            return iter;
        }

        public QueryIterator nextClump() {
            if (!this.inGroup) {
                throw new NoSuchElementException("No more groups");
            }
            this.inGroup = false;
            return this;
        }

        public boolean hasNextClump() {
            return this.inGroup;
        }

        public List getClumpVars() {
            return new ArrayList();
        }

        public void close() {
            if (!this.finished) {
                if (this.currentStage != null) {
                    this.currentStage.close();
                }
                if (this.input != null) {
                    this.input.close();
                }
                this.input = null;
            }
        }

        public void remove() {
            throw new UnsupportedOperationException(Utils.className(this) + ".remove");
        }
    }
}

