/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.query.extension;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import mx.com.hp.hpl.jena.query.engine1.EngineConfig;
import mx.com.hp.hpl.jena.query.extension.Extension;
import mx.com.hp.hpl.jena.query.extension.ExtensionFactory;
import mx.com.hp.hpl.jena.query.extension.ExtensionFactoryAuto;
import mx.com.hp.hpl.jena.query.util.Loader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ExtensionRegistry {
    static Log log = LogFactory.getLog((Class)ExtensionRegistry.class);
    static ExtensionRegistry globalRegistry = null;
    Map registry = new HashMap();
    Set attemptedLoads = new HashSet();

    public static synchronized ExtensionRegistry standardRegistry() {
        ExtensionRegistry reg = new ExtensionRegistry();
        reg.loadStdDefs();
        return reg;
    }

    public static synchronized ExtensionRegistry get() {
        ExtensionRegistry reg = (ExtensionRegistry)EngineConfig.getContext().get(EngineConfig.registryExtensions);
        if (reg == null) {
            reg = ExtensionRegistry.standardRegistry();
            EngineConfig.getContext().set(EngineConfig.registryExtensions, reg);
        }
        return reg;
    }

    public void put(String uri, ExtensionFactory factory) {
        this.registry.put(uri, factory);
    }

    public void put(String uri, Class extClass) {
        if (!Extension.class.isAssignableFrom(extClass)) {
            log.warn((Object)("Class " + extClass.getName() + " is not an Extension"));
            return;
        }
        this.registry.put(uri, new ExtensionFactoryAuto(extClass));
    }

    public ExtensionFactory get(String uri) {
        ExtensionFactory ext = (ExtensionFactory)this.registry.get(uri);
        if (ext != null) {
            return ext;
        }
        if (!uri.startsWith("java:")) {
            return null;
        }
        if (this.attemptedLoads.contains(uri)) {
            return null;
        }
        Class extClass = Loader.loadClass(uri, Extension.class);
        this.put(uri, extClass);
        this.attemptedLoads.add(uri);
        return (ExtensionFactory)this.registry.get(uri);
    }

    public ExtensionFactory remove(String uri) {
        return (ExtensionFactory)this.registry.remove(uri);
    }

    public Iterator keys() {
        return this.registry.keySet().iterator();
    }

    private void loadStdDefs() {
    }
}

