/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.query.extension.library;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import mx.com.hp.hpl.jena.query.core.Binding;
import mx.com.hp.hpl.jena.query.engine.QueryIterator;
import mx.com.hp.hpl.jena.query.engine1.ExecutionContext;
import mx.com.hp.hpl.jena.query.engine1.QueryIter;
import mx.com.hp.hpl.jena.query.engine1.QueryIterPlainWrapper;
import mx.com.hp.hpl.jena.query.expr.Expr;
import mx.com.hp.hpl.jena.query.expr.NodeValue;
import mx.com.hp.hpl.jena.query.expr.NodeVar;
import mx.com.hp.hpl.jena.query.util.Utils;
import mx.com.hp.hpl.jena.util.iterator.NiceIterator;

class QueryIterClump
extends QueryIter {
    static int varNameCount = 1;
    int ind = varNameCount;
    String varName = "AGG" + varNameCount++;
    Expr expr = null;
    QueryIterator input;
    boolean initialized = false;
    Iterator iterators = null;
    List vars = null;
    QueryIterator currentGroup = null;
    boolean finished = false;

    QueryIterClump(QueryIterator qIter, Expr expr, ExecutionContext execCxt) {
        super(execCxt);
        this.vars = qIter.getClumpVars();
        this.expr = expr;
        this.input = qIter;
    }

    public QueryIterator nextClump() {
        if (this.finished) {
            throw new NoSuchElementException(Utils.className(this));
        }
        if (!this.hasNextClump()) {
            throw new NoSuchElementException(Utils.className(this));
        }
        if (this.currentGroup != null) {
            this.currentGroup.close();
        }
        this.currentGroup = (QueryIterator)this.iterators.next();
        return this.currentGroup;
    }

    public boolean hasNextClump() {
        this.init();
        return this.iterators.hasNext();
    }

    public List getClumpVars() {
        return this.vars;
    }

    public boolean hasNextBinding() {
        if (this.finished) {
            return true;
        }
        this.init();
        if (this.currentGroup == null) {
            if (this.hasNextClump()) {
                this.currentGroup = this.nextClump();
            } else {
                return false;
            }
        }
        if (!this.currentGroup.hasNext()) {
            NiceIterator.close((Iterator)((Object)this.currentGroup));
            this.currentGroup = null;
            if (this.hasNextClump()) {
                this.currentGroup = this.nextClump();
            }
        }
        if (this.currentGroup == null) {
            return false;
        }
        return this.currentGroup.hasNext();
    }

    public Binding moveToNextBinding() {
        if (!this.hasNextBinding()) {
            throw new NoSuchElementException("QueryIteratorGroupBase.nextBinding");
        }
        Binding b = (Binding)this.currentGroup.next();
        return b;
    }

    public void closeIterator() {
        this.currentGroup = null;
        this.finished = true;
    }

    private void init() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        if (this.expr instanceof NodeVar) {
            this.vars.add(((NodeVar)this.expr).getVarName());
        }
        ArrayList<QueryIterPlainWrapper> list2 = new ArrayList<QueryIterPlainWrapper>();
        while (this.input.hasNextClump()) {
            ArrayList<Binding> x;
            NodeValue val;
            QueryIterator gIter = this.input.nextClump();
            HashMap<NodeValue, ArrayList<Binding>> grouped = new HashMap<NodeValue, ArrayList<Binding>>();
            while (gIter.hasNext()) {
                Binding binding = gIter.nextBinding();
                val = this.expr.eval(binding, this.getExecContext());
                x = (ArrayList<Binding>)grouped.get(val);
                if (x == null) {
                    x = new ArrayList<Binding>();
                    grouped.put(val, x);
                }
                x.add(binding);
            }
            gIter.close();
            Iterator iter = grouped.keySet().iterator();
            while (iter.hasNext()) {
                val = (NodeValue)iter.next();
                x = (List)grouped.get(val);
                QueryIterPlainWrapper q = new QueryIterPlainWrapper(x.iterator());
                list2.add(q);
            }
        }
        this.input.close();
        this.iterators = list2.iterator();
    }
}

