/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.query.extension.library;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import mx.com.hp.hpl.jena.query.core.Binding;
import mx.com.hp.hpl.jena.query.engine.QueryIterator;
import mx.com.hp.hpl.jena.query.engine1.ExecutionContext;
import mx.com.hp.hpl.jena.query.engine1.QueryIter;
import mx.com.hp.hpl.jena.query.engine1.QueryIterSingleton;
import mx.com.hp.hpl.jena.query.expr.Expr;
import mx.com.hp.hpl.jena.query.expr.NodeValue;
import mx.com.hp.hpl.jena.query.expr.NodeVar;
import mx.com.hp.hpl.jena.query.extension.library.Aggregate;
import mx.com.hp.hpl.jena.query.util.Utils;
import mx.com.hp.hpl.jena.util.iterator.NiceIterator;

class QueryIterGroup
extends QueryIter {
    static int varNameCount = 1;
    int ind = varNameCount;
    String varName = "AGG" + varNameCount++;
    Iterator iterators = null;
    List vars = null;
    Aggregate agg;
    QueryIterator currentGroup = null;
    boolean finished = false;

    QueryIterGroup(QueryIterator input, Expr expr, Aggregate agg, ExecutionContext execCxt) {
        super(execCxt);
        if (expr instanceof NodeVar) {
            this.vars.add(((NodeVar)expr).getVarName());
        }
        List x = this.makeList(input, expr, agg);
        this.iterators = x.iterator();
    }

    private List makeList(QueryIterator input, Expr expr, Aggregate agg) {
        ArrayList<QueryIterSingleton> list2 = new ArrayList<QueryIterSingleton>();
        while (input.hasNextClump()) {
            QueryIterator gIter = input.nextClump();
            agg.startGroup();
            Binding binding = null;
            while (gIter.hasNext()) {
                Binding bb = gIter.nextBinding();
                NodeValue val = expr.eval(binding, this.getExecContext());
                if (binding != null) {
                    binding = bb;
                }
                agg.calc(bb);
            }
            agg.finishGroup();
            gIter.close();
            if (binding == null) continue;
            binding.add(this.varName, agg.get().asNode());
            list2.add(new QueryIterSingleton(binding));
        }
        input.close();
        return list2;
    }

    public QueryIterator nextClump() {
        if (this.finished) {
            throw new NoSuchElementException(Utils.className(this));
        }
        if (!this.hasNextClump()) {
            throw new NoSuchElementException(Utils.className(this));
        }
        if (this.currentGroup != null) {
            this.currentGroup.close();
        }
        this.currentGroup = (QueryIterator)this.iterators.next();
        return this.currentGroup;
    }

    public boolean hasNextClump() {
        return this.iterators.hasNext();
    }

    public List getClumpVars() {
        return this.vars;
    }

    public boolean hasNextBinding() {
        if (this.finished) {
            return true;
        }
        if (this.currentGroup == null) {
            if (this.hasNextClump()) {
                this.currentGroup = this.nextClump();
            } else {
                return false;
            }
        }
        if (!this.currentGroup.hasNext()) {
            NiceIterator.close((Iterator)((Object)this.currentGroup));
            this.currentGroup = null;
            if (this.hasNextClump()) {
                this.currentGroup = this.nextClump();
            }
        }
        if (this.currentGroup == null) {
            return false;
        }
        return this.currentGroup.hasNext();
    }

    public Binding moveToNextBinding() {
        if (!this.hasNextBinding()) {
            throw new NoSuchElementException("QueryIteratorGroupBase.nextBinding");
        }
        Binding b = (Binding)this.currentGroup.next();
        return b;
    }

    public void closeIterator() {
        this.currentGroup = null;
        this.finished = true;
    }
}

