/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.query.extension.library;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import mx.com.hp.hpl.jena.graph.Graph;
import mx.com.hp.hpl.jena.graph.Node;
import mx.com.hp.hpl.jena.query.QueryBuildException;
import mx.com.hp.hpl.jena.query.core.ARQInternalErrorException;
import mx.com.hp.hpl.jena.query.core.Binding;
import mx.com.hp.hpl.jena.query.core.Binding1;
import mx.com.hp.hpl.jena.query.engine.QueryIterator;
import mx.com.hp.hpl.jena.query.engine1.ExecutionContext;
import mx.com.hp.hpl.jena.query.engine1.QueryIterNullIterator;
import mx.com.hp.hpl.jena.query.engine1.QueryIterPlainWrapper;
import mx.com.hp.hpl.jena.query.expr.Expr;
import mx.com.hp.hpl.jena.query.expr.ExprEvalException;
import mx.com.hp.hpl.jena.query.expr.NodeValue;
import mx.com.hp.hpl.jena.query.extension.ExtUtils;
import mx.com.hp.hpl.jena.query.extension.ExtensionBaseUneval;
import mx.com.hp.hpl.jena.query.extension.ExtensionSingleton;
import mx.com.hp.hpl.jena.query.util.GraphUtils;
import mx.com.hp.hpl.jena.query.util.Utils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class container
extends ExtensionBaseUneval {
    private static Log log = LogFactory.getLog((Class)container.class);
    List myArgs = null;
    Node typeNode = null;

    public container() {
        this.typeNode = null;
    }

    protected container(Node typeURI) {
        this.typeNode = typeURI;
    }

    public void build(List args, String uri) {
        if (args.size() != 2) {
            throw new QueryBuildException(Utils.className(this) + ": Must be two arguments");
        }
        this.myArgs = args;
    }

    public QueryIterator execUnevaluated(List args, Binding binding, ExecutionContext execCxt) {
        if (args != this.myArgs) {
            throw new ARQInternalErrorException(Utils.className(this) + ": Arguments have changed since checking");
        }
        Expr container2 = (Expr)args.get(0);
        Expr member = (Expr)args.get(1);
        Graph graph = this.getContext().getActiveGraph();
        Node containerNode = null;
        if ((container2 = ExtUtils.evalToExpr(container2, binding)).isVariable()) {
            throw new ExprEvalException(Utils.className(this) + ": Arg 1 not bound (not implemented yet)");
        }
        if (container2.isConstant()) {
            containerNode = container2.getConstant().asNode();
        }
        if (containerNode == null) {
            throw new ExprEvalException(Utils.className(this) + ": Arg 1 is too hard : " + (Expr)args.get(0));
        }
        if ((member = ExtUtils.evalToExpr(member, binding)) == null) {
            throw new ExprEvalException(Utils.className(this) + ": Arg 2 is strange : " + (Expr)args.get(1));
        }
        if (!member.isVariable() && !member.isConstant()) {
            throw new ExprEvalException(Utils.className(this) + ": Arg 2 is too hard : " + (Expr)args.get(1));
        }
        if (member.isVariable()) {
            String varName = member.getVarName();
            Collection x = GraphUtils.containerMembers(graph, containerNode, this.typeNode);
            if (x == null) {
                return new QueryIterNullIterator(this.getContext());
            }
            ArrayList<Binding1> bindings = new ArrayList<Binding1>();
            Iterator iter = x.iterator();
            while (iter.hasNext()) {
                Node n = (Node)iter.next();
                Binding1 b = new Binding1(varName, n, binding);
                bindings.add(b);
            }
            return new QueryIterPlainWrapper(bindings.iterator(), this.getContext());
        }
        Node n = ((NodeValue)member).asNode();
        if (GraphUtils.isContainerMember(graph, containerNode, this.typeNode, n)) {
            return new ExtensionSingleton(binding);
        }
        return new QueryIterNullIterator(this.getContext());
    }
}

