/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.query.extension.library;

import java.util.List;
import mx.com.hp.hpl.jena.graph.Graph;
import mx.com.hp.hpl.jena.graph.Node;
import mx.com.hp.hpl.jena.query.QueryBuildException;
import mx.com.hp.hpl.jena.query.core.ARQInternalErrorException;
import mx.com.hp.hpl.jena.query.core.Binding;
import mx.com.hp.hpl.jena.query.engine.QueryIterator;
import mx.com.hp.hpl.jena.query.engine1.ExecutionContext;
import mx.com.hp.hpl.jena.query.engine1.QueryIterNullIterator;
import mx.com.hp.hpl.jena.query.expr.Expr;
import mx.com.hp.hpl.jena.query.expr.ExprEvalException;
import mx.com.hp.hpl.jena.query.extension.ExtensionBaseUneval;
import mx.com.hp.hpl.jena.query.extension.ExtensionSingleton;
import mx.com.hp.hpl.jena.query.extension.library.MemberIterator;
import mx.com.hp.hpl.jena.query.util.GraphUtils;
import mx.com.hp.hpl.jena.query.util.Utils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class list
extends ExtensionBaseUneval {
    private static Log log = LogFactory.getLog((Class)list.class);
    List myArgs = null;

    public void build(List args, String uri) {
        if (args.size() != 2) {
            throw new QueryBuildException(Utils.className(this) + ": Must be two arguments");
        }
        this.myArgs = args;
    }

    public QueryIterator execUnevaluated(List args, Binding binding, ExecutionContext execCxt) {
        if (args != this.myArgs) {
            throw new ARQInternalErrorException(Utils.className(this) + ": Arguments have changed since checking");
        }
        Expr list2 = (Expr)args.get(0);
        Expr member = (Expr)args.get(1);
        Node nList = null;
        if (list2.isConstant()) {
            nList = list2.getConstant().getNode();
        } else if (list2.isVariable() && binding.contains(list2.getVarName())) {
            nList = binding.get(list2.getVarName());
        }
        String itemVarName = member.getVarName();
        Graph graph = this.getContext().getActiveGraph();
        if (nList != null) {
            if (itemVarName != null) {
                List members = GraphUtils.listMembers(graph, nList);
                return new MemberIterator(binding, itemVarName, members.iterator(), execCxt);
            }
            Node x = member.eval(binding, execCxt).asNode();
            boolean found = GraphUtils.isListMember(graph, nList, x);
            if (found) {
                return new ExtensionSingleton(binding);
            }
            return new QueryIterNullIterator(null);
        }
        throw new ExprEvalException(Utils.className(this) + ": Arg 1 not bound (not implemented yet)");
    }
}

