/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.query.function;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import mx.com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import mx.com.hp.hpl.jena.query.engine1.EngineConfig;
import mx.com.hp.hpl.jena.query.function.CastXSD;
import mx.com.hp.hpl.jena.query.function.Function;
import mx.com.hp.hpl.jena.query.function.FunctionFactory;
import mx.com.hp.hpl.jena.query.function.FunctionFactoryAuto;
import mx.com.hp.hpl.jena.query.function.library.matches;
import mx.com.hp.hpl.jena.query.util.Loader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FunctionRegistry {
    static Log log = LogFactory.getLog((Class)FunctionRegistry.class);
    Map registry = new HashMap();
    Set attemptedLoads = new HashSet();
    static final String xfn = "http://www.w3.org/2005/04/xpath-functions/#";

    public static synchronized FunctionRegistry standardRegistry() {
        FunctionRegistry reg = new FunctionRegistry();
        reg.loadStdDefs();
        return reg;
    }

    public static synchronized FunctionRegistry get() {
        FunctionRegistry reg = (FunctionRegistry)EngineConfig.getContext().get(EngineConfig.registryFunctions);
        if (reg == null) {
            reg = FunctionRegistry.standardRegistry();
            EngineConfig.getContext().set(EngineConfig.registryFunctions, reg);
        }
        return reg;
    }

    public void put(String uri, FunctionFactory f) {
        this.registry.put(uri, f);
    }

    public void put(String uri, Class funcClass) {
        if (!Function.class.isAssignableFrom(funcClass)) {
            log.warn((Object)("Class " + funcClass.getName() + " is not a Function"));
            return;
        }
        this.registry.put(uri, new FunctionFactoryAuto(funcClass));
    }

    public FunctionFactory get(String uri) {
        FunctionFactory function = (FunctionFactory)this.registry.get(uri);
        if (function != null) {
            return function;
        }
        if (!uri.startsWith("java:")) {
            return null;
        }
        if (this.attemptedLoads.contains(uri)) {
            return null;
        }
        Class functionClass = Loader.loadClass(uri, Function.class);
        this.put(uri, functionClass);
        this.attemptedLoads.add(uri);
        return (FunctionFactory)this.registry.get(uri);
    }

    public FunctionFactory remove(String uri) {
        return (FunctionFactory)this.registry.remove(uri);
    }

    public Iterator keys() {
        return this.registry.keySet().iterator();
    }

    private void loadStdDefs() {
        this.addCast(XSDDatatype.XSDdecimal);
        this.addCast(XSDDatatype.XSDinteger);
        this.addCast(XSDDatatype.XSDlong);
        this.addCast(XSDDatatype.XSDint);
        this.addCast(XSDDatatype.XSDshort);
        this.addCast(XSDDatatype.XSDbyte);
        this.addCast(XSDDatatype.XSDnonPositiveInteger);
        this.addCast(XSDDatatype.XSDnegativeInteger);
        this.addCast(XSDDatatype.XSDnonNegativeInteger);
        this.addCast(XSDDatatype.XSDpositiveInteger);
        this.addCast(XSDDatatype.XSDunsignedLong);
        this.addCast(XSDDatatype.XSDunsignedInt);
        this.addCast(XSDDatatype.XSDunsignedShort);
        this.addCast(XSDDatatype.XSDdouble);
        this.addCast(XSDDatatype.XSDfloat);
        this.addCast(XSDDatatype.XSDdateTime);
        this.addCast(XSDDatatype.XSDboolean);
        this.addCast(XSDDatatype.XSDstring);
        this.addCast(XSDDatatype.XSDanyURI);
        this.put("http://www.w3.org/2005/04/xpath-functions/#matches", matches.class);
    }

    private void addCast(XSDDatatype dt) {
        this.put(dt.getURI(), new CastXSD(dt));
    }
}

