/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.query.function;

import mx.com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import mx.com.hp.hpl.jena.query.expr.ExprEvalException;
import mx.com.hp.hpl.jena.query.expr.NodeValue;
import mx.com.hp.hpl.jena.query.function.FunctionBase1;

class Instance
extends FunctionBase1 {
    XSDDatatype castType;

    Instance(XSDDatatype dt) {
        this.castType = dt;
    }

    public NodeValue exec(NodeValue v) {
        String s = null;
        if (v.isNode()) {
            if (v.getNode().isLiteral()) {
                s = v.getNode().getLiteralLexicalForm();
            } else {
                throw new ExprEvalException("CastXSD: Can't cast node: " + v);
            }
        }
        if (s == null && v.isString()) {
            s = v.getString();
        }
        if (s == null) {
            throw new ExprEvalException("CastXSD: Can't cast: " + v);
        }
        if (!this.castType.isValid(s)) {
            throw new ExprEvalException("CastXSD: Not a valid literal form: " + s);
        }
        NodeValue r = NodeValue.makeNode(s, this.castType);
        return r;
    }
}

