/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.query.junit;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Iterator;
import java.util.List;
import mx.com.hp.hpl.jena.query.Dataset;
import mx.com.hp.hpl.jena.query.DatasetFactory;
import mx.com.hp.hpl.jena.query.Query;
import mx.com.hp.hpl.jena.query.QueryException;
import mx.com.hp.hpl.jena.query.QueryExecution;
import mx.com.hp.hpl.jena.query.QueryExecutionFactory;
import mx.com.hp.hpl.jena.query.QueryFactory;
import mx.com.hp.hpl.jena.query.ResultSet;
import mx.com.hp.hpl.jena.query.ResultSetFactory;
import mx.com.hp.hpl.jena.query.ResultSetFormatter;
import mx.com.hp.hpl.jena.query.junit.TestCaseARQ;
import mx.com.hp.hpl.jena.query.junit.TestItem;
import mx.com.hp.hpl.jena.query.resultset.ResultSetRewindable;
import mx.com.hp.hpl.jena.rdf.model.Model;
import mx.com.hp.hpl.jena.shared.JenaException;
import mx.com.hp.hpl.jena.util.FileManager;
import mx.com.hp.hpl.jena.util.FileUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class QueryTest
extends TestCaseARQ {
    private static Log log = LogFactory.getLog((Class)QueryTest.class);
    static int testCounter = 1;
    static boolean printModelsOnFailure = false;
    Model model;
    int testNumber = testCounter++;
    TestItem testItem;
    FileManager queryFileManager;
    Model resultsModel = null;
    String description = null;

    QueryTest(Model m, String testName, FileManager fm, TestItem t) {
        super(testName);
        this.model = m;
        this.queryFileManager = fm;
        this.testItem = t;
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.description = this.makeDescription();
        if (this.testItem.getResultFile() != null) {
            this.resultsModel = ResultSetFactory.loadAsModel(this.testItem.getResultFile());
        }
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    private Dataset setUpDataset(Query query2, TestItem testItem) {
        try {
            if (QueryTest.doesQueryHaveDataset(query2) && QueryTest.doesTestItemHaveDataset(testItem) && testItem.getResultFile() != null) {
                log.warn((Object)(testItem.getName() + " : query data source and also in test file"));
            }
            if (QueryTest.doesTestItemHaveDataset(testItem)) {
                List defaultGraph = testItem.getDefaultGraphURIs();
                List namedGraph = testItem.getNamedGraphURIs();
                return DatasetFactory.create(defaultGraph, namedGraph);
            }
            if (!QueryTest.doesQueryHaveDataset(query2)) {
                QueryTest.fail((String)"No dataset");
            }
            return null;
        }
        catch (JenaException jEx) {
            log.debug((Object)("JenaException: " + jEx.getMessage()));
            QueryTest.fail((String)("JenaException creating data source: " + jEx.getMessage()));
            return null;
        }
    }

    private static boolean doesTestItemHaveDataset(TestItem testItem) {
        boolean r = testItem.getDefaultGraphURIs() != null && testItem.getDefaultGraphURIs().size() > 0 || testItem.getNamedGraphURIs() != null && testItem.getNamedGraphURIs().size() > 0;
        return r;
    }

    private static boolean doesQueryHaveDataset(Query query2) {
        boolean r = query2.getGraphURIs() != null && query2.getGraphURIs().size() > 0 || query2.getNamedGraphURIs() != null && query2.getNamedGraphURIs().size() > 0;
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runTest() throws Throwable {
        Query query2 = null;
        try {
            if (this.testItem.getQueryFile() == null) {
                QueryTest.fail((String)"Query test file is null");
                return;
            }
            try {
                query2 = QueryFactory.read(this.testItem.getQueryFile(), null, this.testItem.getQueryFileSyntax());
            }
            catch (QueryException qEx) {
                query2 = null;
                QueryTest.fail((String)("Parse failure: " + qEx.getMessage()));
                throw qEx;
            }
            query2.setBaseURI(this.testItem.getBaseURI());
            Dataset dataset = this.setUpDataset(query2, this.testItem);
            if (dataset == null && !QueryTest.doesQueryHaveDataset(query2)) {
                QueryTest.fail((String)"No dataset for query");
            }
            QueryExecution qe = null;
            try {
                qe = dataset != null ? QueryExecutionFactory.create(query2, dataset) : QueryExecutionFactory.create(query2, dataset);
                QueryExecutionFactory.create(query2, this.queryFileManager);
                if (query2.isSelectType()) {
                    this.runTestSelect(query2, qe);
                } else if (query2.isConstructType()) {
                    this.runTestConstruct(query2, qe);
                } else if (query2.isDescribeType()) {
                    this.runTestDescribe(query2, qe);
                } else if (query2.isAskType()) {
                    this.runTestAsk(query2, qe);
                }
            }
            finally {
                qe.close();
            }
        }
        catch (IOException ioEx) {
            QueryTest.fail((String)("IOException: " + ioEx.getMessage()));
            throw ioEx;
        }
        catch (NullPointerException ex) {
            throw ex;
        }
        catch (Exception ex) {
            log.debug((Object)("Exception: " + ex.getMessage()), (Throwable)ex);
            QueryTest.fail((String)("Exception: " + ex.getClass().getName() + ": " + ex.getMessage()));
        }
    }

    void runTestSelect(Query query2, QueryExecution qe) throws Exception {
        ResultSet resultsActual = qe.execSelect();
        ResultSetRewindable results = ResultSetFactory.makeRewindable(resultsActual);
        qe.close();
        resultsActual = null;
        if (this.resultsModel != null) {
            try {
                boolean testByParsingExpectedResults = true;
                if (testByParsingExpectedResults) {
                    ResultSetRewindable qr2;
                    ResultSetRewindable qr1 = ResultSetFactory.makeRewindable(results);
                    if (!QueryTest.resultSetEquivalent(query2, (ResultSet)qr1, qr2 = ResultSetFactory.makeRewindable(this.resultsModel))) {
                        this.printFailedResultSetTest(query2, qr1, qr2);
                        QueryTest.fail((String)("Results do not match: " + this.testItem.getName()));
                    }
                } else {
                    ResultSetRewindable qr1 = ResultSetFactory.makeRewindable(results);
                    if (!QueryTest.resultSetEquivalent(query2, (ResultSet)qr1, this.resultsModel)) {
                        ResultSetRewindable qr2 = ResultSetFactory.makeRewindable(this.resultsModel);
                        this.printFailedResultSetTest(query2, qr1, qr2);
                        QueryTest.fail((String)("Results do not match: " + this.testItem.getName()));
                    }
                }
            }
            catch (Exception ex) {
                log.warn((Object)"Exception in result testing", (Throwable)ex);
                QueryTest.fail((String)("Exception in result testing: " + ex));
            }
        }
    }

    public static boolean resultSetEquivalent(Query query2, ResultSet rs1, ResultSet rs2) {
        Model model2 = ResultSetFormatter.toModel(rs2);
        return QueryTest.resultSetEquivalent(query2, rs1, model2);
    }

    public static boolean resultSetEquivalent(Query query2, ResultSet rs1, Model model2) {
        Model model1 = ResultSetFormatter.toModel(rs1);
        return model1.isIsomorphicWith(model2);
    }

    void runTestConstruct(Query query2, QueryExecution qe) throws Exception {
        Model resultsActual = qe.execConstruct();
        if (this.resultsModel != null) {
            try {
                if (!this.resultsModel.isIsomorphicWith(resultsActual)) {
                    this.printFailedModelTest(query2, resultsActual, this.resultsModel);
                    QueryTest.fail((String)("Results do not match: " + this.testItem.getName()));
                }
            }
            catch (Exception ex) {
                log.warn((Object)"Exception in result testing (construct)", (Throwable)ex);
                QueryTest.fail((String)("Exception in result testing: " + ex));
            }
        }
    }

    void runTestDescribe(Query query2, QueryExecution qe) throws Exception {
        Model resultsActual = qe.execDescribe();
        if (this.resultsModel != null) {
            try {
                if (!this.resultsModel.isIsomorphicWith(resultsActual)) {
                    this.printFailedModelTest(query2, resultsActual, this.resultsModel);
                    QueryTest.fail((String)("Results do not match: " + this.testItem.getName()));
                }
            }
            catch (Exception ex) {
                log.warn((Object)"Exception in result testing (describe)", (Throwable)ex);
                QueryTest.fail((String)("Exception in result testing: " + ex));
            }
        }
    }

    void runTestAsk(Query query2, QueryExecution qe) throws Exception {
    }

    void printFailedResultSetTest(Query query2, ResultSetRewindable qr1, ResultSetRewindable qr2) {
        PrintStream out = System.out;
        out.println();
        out.println("=======================================");
        out.println("Failure: " + this.description);
        out.println("Got: " + qr1.size() + " --------------------------------");
        qr1.reset();
        ResultSetFormatter.out((OutputStream)out, (ResultSet)qr1, query2.getPrefixMapping());
        qr1.reset();
        if (printModelsOnFailure) {
            out.println("-----------------------------------------");
            ResultSetFormatter.toModel(qr1).write((OutputStream)out, "N3");
            qr1.reset();
        }
        out.flush();
        out.println("Expected: " + qr2.size() + " -----------------------------");
        qr2.reset();
        ResultSetFormatter.out((OutputStream)out, (ResultSet)qr2, query2.getPrefixMapping());
        qr2.reset();
        if (printModelsOnFailure) {
            out.println("---------------------------------------");
            ResultSetFormatter.toModel(qr2).write((OutputStream)out, "N3");
            qr2.reset();
        }
        out.println();
        out.flush();
    }

    void printFailedModelTest(Query query2, Model results, Model expected) {
        PrintWriter out = FileUtils.asPrintWriterUTF8((OutputStream)System.out);
        out.println("=======================================");
        out.println("Failure: " + this.description);
        if (printModelsOnFailure) {
            results.write((Writer)out, "N3");
            out.println("---------------------------------------");
            expected.write((Writer)out, "N3");
        }
        out.println();
    }

    public String toString() {
        if (this.testItem.getName() != null) {
            return this.testItem.getName();
        }
        return super.getName();
    }

    private String makeDescription() {
        Iterator iter;
        String tmp = "";
        if (this.testItem.getDefaultGraphURIs() != null) {
            iter = this.testItem.getDefaultGraphURIs().iterator();
            while (iter.hasNext()) {
                tmp = tmp + (String)iter.next();
            }
        }
        if (this.testItem.getNamedGraphURIs() != null) {
            iter = this.testItem.getNamedGraphURIs().iterator();
            while (iter.hasNext()) {
                tmp = tmp + (String)iter.next();
            }
        }
        String d = "Test " + this.testNumber + " :: " + this.testItem.getName();
        return d;
    }
}

