/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.query.junit;

import mx.com.hp.hpl.jena.query.QueryException;
import mx.com.hp.hpl.jena.query.junit.TestCaseARQ;
import mx.com.hp.hpl.jena.query.junit.TestItem;

public class SyntaxTest
extends TestCaseARQ {
    static int count = 0;
    String queryString;
    boolean expectLegalSyntax;
    TestItem testItem;

    public SyntaxTest(String testName, TestItem t) {
        this(testName, t, true);
    }

    public SyntaxTest(String testName, TestItem t, boolean positiveTest) {
        super(testName);
        this.testItem = t;
        this.expectLegalSyntax = positiveTest;
    }

    public SyntaxTest(String queryString, boolean positiveTest) {
        this(positiveTest ? queryString : "X: " + queryString, queryString, positiveTest);
    }

    public SyntaxTest(String queryString) {
        this(queryString, true);
    }

    public SyntaxTest(String testName, String queryString) {
        this(testName, queryString, true);
    }

    public SyntaxTest(String testName, String queryString, boolean positiveTest) {
        super(testName);
        this.setTest(testName, queryString, positiveTest);
    }

    private void setTest(String testName, String _queryString, boolean positiveTest) {
        super.setName(testName);
        this.queryString = _queryString;
        this.expectLegalSyntax = positiveTest;
    }

    protected void runTest() throws Throwable {
        try {
            if (this.queryString == null) {
                this.queryFromTestItem(this.testItem);
            } else {
                this.queryFromString(this.queryString);
            }
            if (!this.expectLegalSyntax) {
                SyntaxTest.fail((String)"Expected parse failure");
            }
        }
        catch (QueryException qEx) {
            if (this.expectLegalSyntax) {
                throw qEx;
            }
        }
        catch (Exception ex) {
            SyntaxTest.fail((String)("Exception: " + ex.getClass().getName() + ": " + ex.getMessage()));
        }
    }
}

