/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.query.junit;

import java.io.ByteArrayInputStream;
import junit.framework.TestCase;
import mx.com.hp.hpl.jena.query.ARQ;
import mx.com.hp.hpl.jena.query.Query;
import mx.com.hp.hpl.jena.query.QueryException;
import mx.com.hp.hpl.jena.query.QueryFactory;
import mx.com.hp.hpl.jena.query.QueryParseException;
import mx.com.hp.hpl.jena.query.core.Binding;
import mx.com.hp.hpl.jena.query.core.BindingMap;
import mx.com.hp.hpl.jena.query.engine1.ExecutionContext;
import mx.com.hp.hpl.jena.query.expr.Expr;
import mx.com.hp.hpl.jena.query.expr.NodeValue;
import mx.com.hp.hpl.jena.query.lang.arq.ARQParser;
import mx.com.hp.hpl.jena.query.lang.sparql.ParseException;
import mx.com.hp.hpl.jena.query.lang.sparql.SPARQLParser;
import mx.com.hp.hpl.jena.query.lang.sparql.TokenMgrError;
import mx.com.hp.hpl.jena.shared.JenaException;

public abstract class TestExpr
extends TestCase {
    public static final int NO_FAILURE = 100;
    public static final int PARSE_FAIL = 250;
    public static final int EVAL_FAIL = 200;
    String testName;
    String exprString;
    Query query;
    Binding binding;
    int failureMode;
    boolean doEval;
    ExecutionContext execCxt = new ExecutionContext(ARQ.getContext(), null, null);

    protected TestExpr(String label, String expression, Query queryCxt, Binding env, int failureOutcome) {
        this.testName = label;
        this.doEval = true;
        String n = label.replace('(', '[').replace(')', ']');
        switch (failureOutcome) {
            case 100: {
                break;
            }
            case 250: {
                n = n + " [Parse fail]";
                break;
            }
            case 200: {
                n = n + " [Eval fail]";
                break;
            }
            default: {
                n = n + " [Unknown fail]";
            }
        }
        this.setName(n);
        this.exprString = expression;
        if (queryCxt == null) {
            queryCxt = QueryFactory.make();
        }
        this.query = queryCxt;
        if (env == null) {
            env = new BindingMap();
        }
        this.binding = env;
        this.failureMode = failureOutcome;
    }

    protected void runTest() throws Throwable {
        Expr expr = null;
        try {
            expr = this.parse(this.exprString);
        }
        catch (Error err) {
            TestExpr.fail((String)("Error thrown in parse: " + err));
        }
        catch (Exception ex) {
            if (this.failureMode != 250) {
                TestExpr.fail((String)("Unexpected parsing failure: " + ex));
            }
            this.checkException(expr, ex);
            return;
        }
        if (this.failureMode == 250) {
            TestExpr.fail((String)("Test should have failed in parsing: " + expr));
            return;
        }
        this.checkExpr(expr);
        if (!this.doEval) {
            return;
        }
        try {
            NodeValue v = expr.eval(this.binding, this.execCxt);
            this.checkValue(expr, v);
        }
        catch (NullPointerException ex) {
            throw ex;
        }
        catch (Exception ex) {
            this.checkException(expr, ex);
        }
    }

    private Expr parse(String exprString) throws Throwable {
        ByteArrayInputStream in = new ByteArrayInputStream(exprString.getBytes());
        try {
            return this.parseSPARQL(in);
        }
        catch (QueryParseException ex) {
            throw ex;
        }
        catch (QueryException ex) {
            throw ex;
        }
        catch (JenaException ex) {
            throw new QueryException(ex.getMessage(), ex);
        }
        catch (Throwable th) {
            th.printStackTrace(System.err);
            TestExpr.fail((String)("Unexpected throwable: " + th));
            throw new QueryParseException(th);
        }
    }

    private Expr parseARQ(ByteArrayInputStream in) throws Throwable {
        try {
            ARQParser parser = new ARQParser(in);
            parser.setQuery(this.query);
            return parser.Expression();
        }
        catch (mx.com.hp.hpl.jena.query.lang.arq.ParseException ex) {
            throw new QueryParseException(ex.getMessage());
        }
        catch (mx.com.hp.hpl.jena.query.lang.arq.TokenMgrError tErr) {
            throw new QueryParseException(tErr.getMessage());
        }
        catch (Error err) {
            String tmp = err.getMessage();
            if (tmp == null) {
                throw new QueryParseException(err);
            }
            throw new QueryParseException(tmp);
        }
    }

    private Expr parseSPARQL(ByteArrayInputStream in) throws Throwable {
        try {
            SPARQLParser parser = new SPARQLParser(in);
            parser.setQuery(this.query);
            return parser.Expression();
        }
        catch (ParseException ex) {
            throw new QueryParseException(ex.getMessage());
        }
        catch (TokenMgrError tErr) {
            throw new QueryParseException(tErr.getMessage());
        }
        catch (Error err) {
            String tmp = err.getMessage();
            if (tmp == null) {
                throw new QueryParseException(err);
            }
            throw new QueryParseException(tmp);
        }
    }

    protected boolean failureCorrect() {
        return this.failureMode != 100;
    }

    protected boolean evalCorrect() {
        return this.failureMode != 200;
    }

    abstract void checkExpr(Expr var1);

    abstract void checkValue(Expr var1, NodeValue var2);

    abstract void checkException(Expr var1, Exception var2);

    public String toString() {
        return this.testName;
    }
}

