/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.query.junit;

import mx.com.hp.hpl.jena.query.Query;
import mx.com.hp.hpl.jena.query.core.Binding;
import mx.com.hp.hpl.jena.query.expr.Expr;
import mx.com.hp.hpl.jena.query.expr.NodeValue;
import mx.com.hp.hpl.jena.query.junit.TestExpr;

public class TestExprNumeric
extends TestExpr {
    boolean isDouble = false;
    long rightAnswerLong;
    double rightAnswerDouble;

    public TestExprNumeric(String exprStr, long rightAnswer) {
        this(exprStr, rightAnswer, null, null);
    }

    public TestExprNumeric(String exprStr, long rightAnswer, Query query2, Binding env) {
        super("Numeric test : " + exprStr + " ", exprStr, query2, env, 100);
        this.rightAnswerLong = rightAnswer;
        this.isDouble = false;
    }

    public TestExprNumeric(String exprStr, double rightAnswer) {
        this(exprStr, rightAnswer, null, null, 100);
    }

    public TestExprNumeric(String exprStr, double rightAnswer, Query query2, Binding env, int failureMode) {
        super("Numeric test : " + exprStr + " ", exprStr, query2, env, failureMode);
        this.rightAnswerDouble = rightAnswer;
        this.isDouble = true;
    }

    void checkExpr(Expr expr) {
    }

    void checkValue(Expr expr, NodeValue nodeValue) {
        if (!this.evalCorrect()) {
            TestExprNumeric.fail((String)(this.exprString + " => " + expr + " :: Expected eval exception but got: " + nodeValue));
        }
        if (!this.isDouble) {
            TestExprNumeric.assertEquals((String)("Parse " + this.exprString + " ==> " + expr + " "), (long)this.rightAnswerLong, (long)nodeValue.getInteger());
        } else {
            TestExprNumeric.assertEquals((String)("Parse " + this.exprString + " => " + expr + " "), (double)this.rightAnswerDouble, (double)nodeValue.getDouble(), (double)1.0E-4);
        }
    }

    void checkException(Expr expr, Exception ex) {
        if (!this.failureCorrect()) {
            TestExprNumeric.fail((String)(this.exprString + " => " + expr + " :: Exception: " + ex));
        }
    }
}

