/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.query.junit;

import java.util.ArrayList;
import java.util.List;
import mx.com.hp.hpl.jena.query.DataFormat;
import mx.com.hp.hpl.jena.query.Syntax;
import mx.com.hp.hpl.jena.query.junit.QueryTestException;
import mx.com.hp.hpl.jena.query.junit.TestUtils;
import mx.com.hp.hpl.jena.query.vocabulary.TestManifest;
import mx.com.hp.hpl.jena.query.vocabulary.VocabTestQuery;
import mx.com.hp.hpl.jena.rdf.model.Model;
import mx.com.hp.hpl.jena.rdf.model.Resource;
import mx.com.hp.hpl.jena.rdf.model.Statement;
import mx.com.hp.hpl.jena.rdf.model.StmtIterator;
import mx.com.hp.hpl.jena.vocabulary.RDF;
import mx.com.hp.hpl.jena.vocabulary.RDFS;

class TestItem {
    Resource testResource = null;
    private Resource actionResource;
    private String name;
    private String resultFile;
    private String comment;
    private List defaultGraphURIs;
    private List namedGraphURIs;
    private Resource testType = null;
    private String baseURI;
    String queryFile;
    Syntax queryFileSyntax;
    Resource queryForm;
    Resource resultForm;

    public String getName() {
        return this.name;
    }

    public String getResultFile() {
        return this.resultFile;
    }

    public String getComment() {
        return this.comment;
    }

    public List getDefaultGraphURIs() {
        return this.defaultGraphURIs;
    }

    public List getNamedGraphURIs() {
        return this.namedGraphURIs;
    }

    public Resource getTestType() {
        return this.testType;
    }

    public void setBaseURI(String baseURI) {
        this.baseURI = baseURI;
    }

    public String getBaseURI() {
        return this.baseURI;
    }

    public String getQueryFile() {
        return this.queryFile;
    }

    public Syntax getQueryFileSyntax() {
        return this.queryFileSyntax;
    }

    public Resource getQueryForm() {
        return this.queryForm;
    }

    public Resource getResultForm() {
        return this.resultForm;
    }

    TestItem(Resource r, Resource defaultTestType, Syntax defaultQuerySyntax, DataFormat defaultDataSyntax) {
        this.testResource = r;
        if (!r.hasProperty(TestManifest.action)) {
            throw new QueryTestException("TestItem with no action");
        }
        if (!r.hasProperty(TestManifest.name)) {
            throw new QueryTestException("TestItem with no name");
        }
        this.testType = TestUtils.getResource(r, RDF.type);
        if (this.testType == null) {
            this.testType = defaultTestType;
        }
        this.queryFileSyntax = defaultQuerySyntax;
        this.name = this._getName();
        this.resultFile = this._getResultFile();
        this.comment = this._getComment();
        this.defaultGraphURIs = this._getDefaultGraphURIs();
        this.namedGraphURIs = this._getNamedGraphsURIs();
        this.queryFile = this._getQueryFile();
        this.queryFileSyntax = this._getSyntax(r.getModel(), this.queryFile, defaultQuerySyntax);
        if (this.queryFileSyntax == null && this.queryFile != null) {
            this.queryFileSyntax = Syntax.guessQueryFileSyntax(this.queryFile);
        }
        this.queryForm = this._getQueryForm();
        this.resultForm = this._getResultForm();
    }

    public Resource getResource() {
        return this.testResource;
    }

    String _getName() {
        Statement s = this.testResource.getProperty(TestManifest.name);
        if (s == null) {
            return "<<unset>>";
        }
        return s.getString();
    }

    Resource _getAction() {
        if (this.actionResource == null) {
            this.actionResource = this.testResource.getProperty(TestManifest.action).getResource();
        }
        return this.actionResource;
    }

    String _getResultFile() {
        return TestUtils.getLiteralOrURI(this.testResource, TestManifest.result);
    }

    String _getComment() {
        Statement s = this.testResource.getProperty(RDFS.comment);
        if (s == null) {
            return null;
        }
        return s.getString();
    }

    List _getDefaultGraphURIs() {
        if (!this._getAction().isAnon()) {
            return null;
        }
        ArrayList<String> l = new ArrayList<String>();
        StmtIterator cIter = this._getAction().listProperties(VocabTestQuery.data);
        while (cIter.hasNext()) {
            Object obj = cIter.next();
            String df = ((Statement)obj).getResource().getURI();
            l.add(df);
        }
        cIter.close();
        return l;
    }

    List _getNamedGraphsURIs() {
        if (!this._getAction().isAnon()) {
            return null;
        }
        ArrayList<String> l = new ArrayList<String>();
        StmtIterator cIter = this._getAction().listProperties(VocabTestQuery.graphData);
        while (cIter.hasNext()) {
            Object obj = cIter.next();
            String df = ((Statement)obj).getResource().getURI();
            l.add(df);
        }
        cIter.close();
        return l;
    }

    String _getQueryFile() {
        Resource r = this._getAction();
        if (r.hasProperty(VocabTestQuery.query)) {
            return TestUtils.getLiteralOrURI(r, VocabTestQuery.query);
        }
        if (this._getAction().isAnon()) {
            return "[]";
        }
        return this._getAction().getURI();
    }

    Resource _getQueryForm() {
        return null;
    }

    Resource _getResultForm() {
        return null;
    }

    Syntax _getSyntax(Model m, String uri, Syntax def) {
        Resource r = m.createResource(uri);
        if (r.hasProperty(RDF.type)) {
            return Syntax.make(r.getProperty(RDF.type).getResource().getURI());
        }
        return def;
    }

    public String toString() {
        StringBuffer sbuff = new StringBuffer();
        String name = this.getName();
        sbuff.append("Name: " + name);
        if (this.getComment() != null) {
            sbuff.append("    Comment: " + this.getComment());
        }
        return sbuff.toString();
    }
}

