/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.query.junit;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import mx.com.hp.hpl.jena.query.DataFormat;
import mx.com.hp.hpl.jena.query.Syntax;
import mx.com.hp.hpl.jena.query.junit.QueryTestException;
import mx.com.hp.hpl.jena.query.junit.TestItem;
import mx.com.hp.hpl.jena.query.junit.TestUtils;
import mx.com.hp.hpl.jena.query.util.RelURI;
import mx.com.hp.hpl.jena.query.vocabulary.TestManifest;
import mx.com.hp.hpl.jena.query.vocabulary.TestManifestX;
import mx.com.hp.hpl.jena.rdf.model.Model;
import mx.com.hp.hpl.jena.rdf.model.RDFNode;
import mx.com.hp.hpl.jena.rdf.model.Resource;
import mx.com.hp.hpl.jena.rdf.model.Statement;
import mx.com.hp.hpl.jena.rdf.model.StmtIterator;
import mx.com.hp.hpl.jena.util.FileManager;
import mx.com.hp.hpl.jena.vocabulary.RDF;
import mx.com.hp.hpl.jena.vocabulary.RDFS;
import org.apache.commons.logging.LogFactory;

class TestManifestList {
    Model manifest = null;
    List testEntries = new ArrayList();
    List includedFiles = new ArrayList();
    String name = null;
    String realName = null;
    static /* synthetic */ Class class$mx$com$hp$hpl$jena$query$junit$TestManifestList;

    public TestManifestList(String filename) {
        filename = RelURI.resolve(filename);
        this.manifest = FileManager.get().loadModel(filename);
        this.parseManifestModel();
    }

    public Model getModel() {
        return this.manifest;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String n) {
        this.realName = n;
        String tmp = n;
        tmp = tmp.replace('(', '{');
        this.name = tmp = tmp.replace(')', '}');
    }

    public Iterator iterator() {
        return this.testEntries.iterator();
    }

    public Iterator includedManifests() {
        return this.includedFiles.iterator();
    }

    private void parseManifestModel() {
        this.parseIncludes();
        this.parseTests();
    }

    private void parseIncludes() {
        StmtIterator includeStmts = this.manifest.listStatements(null, TestManifestX.include, (RDFNode)null);
        while (includeStmts.hasNext()) {
            Statement s = includeStmts.nextStatement();
            if (!(s.getObject() instanceof Resource)) {
                LogFactory.getLog((Class)(class$mx$com$hp$hpl$jena$query$junit$TestManifestList == null ? TestManifestList.class$("mx.com.hp.hpl.jena.query.junit.TestManifestList") : class$mx$com$hp$hpl$jena$query$junit$TestManifestList)).warn((Object)("Include: not a Resource" + s));
                continue;
            }
            Resource r = s.getResource();
            this.parseIncludes(r);
        }
        includeStmts.close();
    }

    private void parseIncludes(Resource r) {
        if (r == null) {
            return;
        }
        if (r.equals(RDF.nil)) {
            return;
        }
        if (!r.isAnon()) {
            String uri = r.getURI();
            if (this.includedFiles.contains(uri)) {
                return;
            }
            this.includedFiles.add(r.getURI());
            return;
        }
        Resource listItem = r;
        while (!listItem.equals(RDF.nil)) {
            r = listItem.getRequiredProperty(RDF.first).getResource();
            this.parseIncludes(r);
            listItem = listItem.getRequiredProperty(RDF.rest).getResource();
        }
    }

    private void parseTests() {
        StmtIterator manifestStmts = this.manifest.listStatements(null, RDF.type, (RDFNode)TestManifest.Manifest);
        while (manifestStmts.hasNext()) {
            Syntax querySyntax;
            Statement manifestItemStmt = manifestStmts.nextStatement();
            Resource manifestRes = manifestItemStmt.getSubject();
            String name = TestUtils.getLiteral(manifestRes, RDFS.label);
            if (name == null) {
                name = TestUtils.getLiteral(manifestRes, RDFS.comment);
            }
            if (name != null) {
                this.setName(name);
            }
            if (!((querySyntax = TestUtils.getQuerySyntax(manifestRes)) == null || querySyntax.equals(Syntax.syntaxRDQL) || querySyntax.equals(Syntax.syntaxARQ) || querySyntax.equals(Syntax.syntaxSPARQL))) {
                throw new QueryTestException("Unknown syntax: " + querySyntax);
            }
            Resource defaultTestType = TestUtils.getResource(manifestRes, TestManifestX.defaultTestType);
            StmtIterator listIter = manifestRes.listProperties(TestManifest.entries);
            while (listIter.hasNext()) {
                Resource listItem = listIter.nextStatement().getResource();
                while (!listItem.equals(RDF.nil)) {
                    Resource entry = listItem.getRequiredProperty(RDF.first).getResource();
                    TestItem item = new TestItem(entry, defaultTestType, querySyntax, DataFormat.langXML);
                    this.testEntries.add(item);
                    listItem = listItem.getRequiredProperty(RDF.rest).getResource();
                }
            }
            listIter.close();
        }
        manifestStmts.close();
    }

    public void apply(ActionProc actionProc) {
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            TestItem item = (TestItem)iter.next();
            actionProc.map1(item);
        }
    }

    public static interface ActionProc {
        public void map1(TestItem var1);
    }
}

