/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.query.junit;

import java.util.Iterator;
import junit.framework.Test;
import junit.framework.TestSuite;
import mx.com.hp.hpl.jena.query.junit.QueryTest;
import mx.com.hp.hpl.jena.query.junit.SerializerTest;
import mx.com.hp.hpl.jena.query.junit.SyntaxTest;
import mx.com.hp.hpl.jena.query.junit.TestCaseARQ;
import mx.com.hp.hpl.jena.query.junit.TestItem;
import mx.com.hp.hpl.jena.query.junit.TestManifestList;
import mx.com.hp.hpl.jena.query.util.RelURI;
import mx.com.hp.hpl.jena.query.vocabulary.TestManifestX;
import mx.com.hp.hpl.jena.rdf.model.Model;
import mx.com.hp.hpl.jena.shared.JenaException;
import mx.com.hp.hpl.jena.util.FileManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TestScripts
extends TestSuite {
    private static Log log = LogFactory.getLog((Class)TestScripts.class);
    private int subManifestCounter = 0;
    static int arqTestCounter = 0;

    public TestScripts(String name) {
        super(name);
    }

    public static TestSuite makeTestSuite(String name, String manifest) {
        TestScripts ts = new TestScripts(name, manifest);
        return ts;
    }

    public static TestSuite makeTestSuite(String manifest) {
        TestScripts ts = new TestScripts("NoName", manifest);
        return ts;
    }

    public TestScripts(String name, String manifest) {
        super(name);
        this.addTests(manifest);
    }

    public void addTest(TestItem item) {
        this.addTest("ARQ-test-" + ++arqTestCounter, item);
    }

    public void addTest(String testName, TestItem item) {
        this.addTest(null, testName, item);
    }

    public void addTest(Model model, String testName, TestItem item) {
        FileManager fm = FileManager.get();
        TestCaseARQ test = null;
        if (item.getTestType() != null) {
            if (item.getTestType().equals(TestManifestX.TestSyntax)) {
                test = new SyntaxTest(testName, item);
            }
            if (item.getTestType().equals(TestManifestX.TestBadSyntax)) {
                test = new SyntaxTest(testName, item, false);
            }
            if (item.getTestType().equals(TestManifestX.TestSerialization)) {
                test = new SerializerTest(testName, item);
            }
            if (item.getTestType().equals(TestManifestX.TestQuery)) {
                test = new QueryTest(model, testName, fm, item);
            }
        }
        if (test == null) {
            test = new QueryTest(model, testName, fm, item);
        }
        this.addTest((Test)test);
    }

    protected void addTests(String testsFile) {
        this.addTests(null, testsFile);
    }

    protected void addTests(Model model, String testsFile) {
        String baseURI = RelURI.chooseBaseURI(testsFile);
        TestManifestList manifest = null;
        try {
            manifest = new TestManifestList(testsFile);
        }
        catch (JenaException ex) {
            log.warn((Object)("Problems loading " + testsFile + ": " + ex.getMessage()));
            return;
        }
        catch (Exception ex) {
            log.warn((Object)("Problems loading " + testsFile), (Throwable)ex);
            return;
        }
        if (manifest.getName() != null) {
            this.setName(manifest.getName());
        }
        Iterator iter = manifest.includedManifests();
        while (iter.hasNext()) {
            String uri = (String)iter.next();
            log.debug((Object)("Included: " + uri));
            String tmp = this.getName() + ++this.subManifestCounter;
            TestSuite subManifest = TestScripts.makeTestSuite(tmp, uri);
            this.addTest((Test)subManifest);
        }
        iter = manifest.iterator();
        while (iter.hasNext()) {
            TestItem item = (TestItem)iter.next();
            item.setBaseURI(baseURI);
            this.addTest(model, item.getName(), item);
        }
    }
}

