/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.query.junit;

import mx.com.hp.hpl.jena.query.Syntax;
import mx.com.hp.hpl.jena.query.junit.QueryTestException;
import mx.com.hp.hpl.jena.query.util.FmtUtils;
import mx.com.hp.hpl.jena.query.vocabulary.TestManifest;
import mx.com.hp.hpl.jena.rdf.model.Literal;
import mx.com.hp.hpl.jena.rdf.model.Property;
import mx.com.hp.hpl.jena.rdf.model.RDFNode;
import mx.com.hp.hpl.jena.rdf.model.Resource;

public class TestUtils {
    static boolean hasQuerySyntax(Resource r) {
        return r.hasProperty(TestManifest.querySyntax);
    }

    static Syntax getQuerySyntax(Resource r) {
        return Syntax.make(TestUtils.getLiteralOrURI(r, TestManifest.querySyntax));
    }

    static String getDataSyntax(Resource r) {
        return TestUtils.getLiteralOrURI(r, TestManifest.dataSyntax);
    }

    static Resource getResource(Resource r, Property p) {
        if (r == null) {
            return null;
        }
        if (!r.hasProperty(p)) {
            return null;
        }
        RDFNode n = r.getProperty(p).getObject();
        if (n instanceof Resource) {
            return (Resource)n;
        }
        throw new QueryTestException("Manifest problem (not a Resource): " + FmtUtils.stringForRDFNode(n) + " => " + FmtUtils.stringForRDFNode((RDFNode)p));
    }

    static String getLiteral(Resource r, Property p) {
        if (r == null) {
            return null;
        }
        if (!r.hasProperty(p)) {
            return null;
        }
        RDFNode n = r.getProperty(p).getObject();
        if (n instanceof Literal) {
            return ((Literal)n).getLexicalForm();
        }
        throw new QueryTestException("Manifest problem (not a Literal): " + FmtUtils.stringForRDFNode(n) + " => " + FmtUtils.stringForRDFNode((RDFNode)p));
    }

    static String getLiteralOrURI(Resource r, Property p) {
        Resource r2;
        if (r == null) {
            return null;
        }
        if (!r.hasProperty(p)) {
            return null;
        }
        RDFNode n = r.getProperty(p).getObject();
        if (n instanceof Literal) {
            return ((Literal)n).getLexicalForm();
        }
        if (n instanceof Resource && !(r2 = (Resource)n).isAnon()) {
            return r2.getURI();
        }
        throw new QueryTestException("Manifest problem: " + FmtUtils.stringForRDFNode(n) + " => " + FmtUtils.stringForRDFNode((RDFNode)p));
    }
}

