/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.query.lang;

import mx.com.hp.hpl.jena.query.Query;
import mx.com.hp.hpl.jena.query.QueryParseException;
import mx.com.hp.hpl.jena.query.Syntax;
import mx.com.hp.hpl.jena.query.lang.ParserARQ;
import mx.com.hp.hpl.jena.query.lang.ParserN3QL;
import mx.com.hp.hpl.jena.query.lang.ParserRDQL;
import mx.com.hp.hpl.jena.query.lang.ParserSPARQL;
import mx.com.hp.hpl.jena.query.lang.ParserXML;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class Parser {
    static Log log = LogFactory.getLog((Class)Parser.class);

    public abstract Query parse(Query var1, String var2) throws QueryParseException;

    public static boolean canParse(Syntax syntaxURI) {
        Parser p = Parser.createParser(syntaxURI);
        return p != null;
    }

    public static Parser createParser(Syntax syntaxURI) {
        if (syntaxURI.equals(Syntax.syntaxSPARQL)) {
            return new ParserSPARQL();
        }
        if (syntaxURI.equals(Syntax.syntaxSPARQL_X)) {
            return new ParserXML();
        }
        if (syntaxURI.equals(Syntax.syntaxARQ)) {
            return new ParserARQ();
        }
        if (syntaxURI.equals(Syntax.syntaxRDQL)) {
            return new ParserRDQL();
        }
        if (syntaxURI.equals(Syntax.syntaxN3QL)) {
            return new ParserN3QL();
        }
        return null;
    }

    protected static void validateParsedQuery(Query query2) {
        if (query2.isSelectType() && query2.getQueryBlock() == null) {
            throw new QueryParseException("Missing WHERE clause in SELECT query");
        }
        if (query2.isConstructType() && query2.getQueryBlock() == null) {
            throw new QueryParseException("Missing WHERE clause in CONSTRUCT query");
        }
        if (query2.isDescribeType()) {
            // empty if block
        }
        if (query2.isAskType() && query2.getQueryBlock() == null) {
            throw new QueryParseException("Missing WHERE clause in ASK query");
        }
    }
}

