/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.query.lang;

import java.io.StringReader;
import mx.com.hp.hpl.jena.query.Query;
import mx.com.hp.hpl.jena.query.QueryException;
import mx.com.hp.hpl.jena.query.QueryParseException;
import mx.com.hp.hpl.jena.query.Syntax;
import mx.com.hp.hpl.jena.query.lang.Parser;
import mx.com.hp.hpl.jena.query.lang.arq.ARQParser;
import mx.com.hp.hpl.jena.query.lang.arq.ParseException;
import mx.com.hp.hpl.jena.query.lang.arq.TokenMgrError;
import mx.com.hp.hpl.jena.shared.JenaException;

class ParserARQ
extends Parser {
    ParserARQ() {
    }

    public Query parse(Query query2, String s) {
        try {
            query2.setStrict(true);
            StringReader in = new StringReader(s);
            ARQParser parser = new ARQParser(in);
            parser.setQuery(query2);
            parser.CompilationUnit();
            query2.setSyntax(Syntax.syntaxARQ);
            ParserARQ.validateParsedQuery(query2);
            return query2;
        }
        catch (ParseException ex) {
            throw new QueryParseException(ex.getMessage());
        }
        catch (TokenMgrError tErr) {
            throw new QueryParseException(tErr.getMessage());
        }
        catch (QueryException ex) {
            throw ex;
        }
        catch (JenaException ex) {
            throw new QueryException(ex.getMessage(), ex);
        }
        catch (Error err) {
            throw new QueryParseException(err.getMessage(), err);
        }
        catch (Throwable th) {
            Parser.log.warn((Object)"Unexpected throwable: ", th);
            throw new QueryParseException(th.getMessage(), th);
        }
    }
}

