/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.query.lang;

import mx.com.hp.hpl.jena.datatypes.RDFDatatype;
import mx.com.hp.hpl.jena.datatypes.TypeMapper;
import mx.com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import mx.com.hp.hpl.jena.graph.Node;
import mx.com.hp.hpl.jena.graph.Triple;
import mx.com.hp.hpl.jena.query.ARQ;
import mx.com.hp.hpl.jena.query.Query;
import mx.com.hp.hpl.jena.query.QueryParseException;
import mx.com.hp.hpl.jena.query.core.Element;
import mx.com.hp.hpl.jena.query.core.ElementGroup;
import mx.com.hp.hpl.jena.query.core.TripleCollector;
import mx.com.hp.hpl.jena.query.expr.Expr;
import mx.com.hp.hpl.jena.query.expr.NodeValue;
import mx.com.hp.hpl.jena.query.expr.NodeVar;
import mx.com.hp.hpl.jena.query.lang.QNameException;
import mx.com.hp.hpl.jena.query.util.JenaURIException;
import mx.com.hp.hpl.jena.query.util.LabelToNodeMap;
import mx.com.hp.hpl.jena.query.util.RelURI;
import mx.com.hp.hpl.jena.rdf.model.AnonId;
import mx.com.hp.hpl.jena.vocabulary.RDF;

public class ParserBase {
    protected final Node XSD_TRUE = Node.createLiteral((String)"true", null, (RDFDatatype)XSDDatatype.XSDboolean);
    protected final Node XSD_FALSE = Node.createLiteral((String)"false", null, (RDFDatatype)XSDDatatype.XSDboolean);
    protected final Node nRDFtype = RDF.type.asNode();
    protected final Node nRDFnil = RDF.nil.asNode();
    protected final Node nRDFfirst = RDF.first.asNode();
    protected final Node nRDFrest = RDF.rest.asNode();
    protected final Node nRDFsubject = RDF.subject.asNode();
    protected final Node nRDFpredicate = RDF.predicate.asNode();
    protected final Node nRDFobject = RDF.object.asNode();
    protected boolean inConstructTemplate = false;
    LabelToNodeMap bNodeLabels = new LabelToNodeMap(false);
    LabelToNodeMap anonVarLabels;
    LabelToNodeMap activeLabelMap = this.anonVarLabels = new LabelToNodeMap(true);
    Query query;
    static final String bNodeLabelStart = "_:";
    boolean skolomizedBNodes = ARQ.getContext().isTrue(ARQ.constantBNodeLabels);

    public void setQuery(Query q) {
        this.query = q;
    }

    public Query getQuery() {
        return this.query;
    }

    protected void setInConstructTemplate(boolean b) {
        this.inConstructTemplate = b;
        this.activeLabelMap = this.inConstructTemplate ? this.bNodeLabels : this.anonVarLabels;
    }

    protected Element compressGroupOfOneGroup(ElementGroup elg) {
        Element e1;
        if (elg.getElements().size() == 1 && (e1 = (Element)elg.getElements().get(0)) instanceof ElementGroup) {
            return e1;
        }
        return elg;
    }

    protected Node makeNodeInteger(String lexicalForm) {
        return Node.createLiteral((String)lexicalForm, null, (RDFDatatype)XSDDatatype.XSDinteger);
    }

    protected Node makeNodeInteger(long value) {
        return Node.createLiteral((String)Long.toString(value), null, (RDFDatatype)XSDDatatype.XSDinteger);
    }

    protected Node makeNodeDouble(String lexicalForm) {
        return Node.createLiteral((String)lexicalForm, null, (RDFDatatype)XSDDatatype.XSDdouble);
    }

    protected Node makeNode(String lexicalForm, String langTag, Node datatype) {
        String uri = datatype == null ? null : datatype.getURI();
        return this.makeNode(lexicalForm, langTag, uri);
    }

    protected Node makeNode(String lexicalForm, String langTag, String datatypeURI) {
        Node n = null;
        if (datatypeURI != null) {
            RDFDatatype dType = TypeMapper.getInstance().getSafeTypeByName(datatypeURI);
            n = Node.createLiteral((String)lexicalForm, null, (RDFDatatype)dType);
        } else {
            n = Node.createLiteral((String)lexicalForm, (String)langTag, null);
        }
        return n;
    }

    protected long integerValue(String s) {
        if (s.startsWith("+")) {
            s = s.substring(1);
        }
        if (s.startsWith("0x")) {
            s = s.substring(2);
            return Long.parseLong(s, 16);
        }
        return Long.parseLong(s);
    }

    protected double doubleValue(String s) {
        if (s.startsWith("+")) {
            s = s.substring(1);
        }
        double valDouble = Double.parseDouble(s);
        return valDouble;
    }

    protected String stripQuotes(String s) {
        return s.substring(1, s.length() - 1);
    }

    protected String stripChars(String s, int n) {
        return s.substring(n, s.length());
    }

    protected Node createVariable(String s, int line, int column) {
        s = s.substring(1);
        s = this.unescapeCodePoint(s, line, column);
        return Node.createVariable((String)s);
    }

    protected Node createURIfromQName(String s, int line, int column) {
        s = this.unescapeCodePoint(s, line, column);
        s = this.fixupQName(s, line, column);
        return Node.createURI((String)s);
    }

    protected Node createNodeFromURI(String s, int line, int column) {
        s = this.stripQuotes(s);
        String uriStr = s = this.unescapeCodePoint(s, line, column);
        if (this.skolomizedBNodes && s.startsWith(bNodeLabelStart)) {
            s = s.substring(bNodeLabelStart.length());
            Node n = Node.createAnon((AnonId)new AnonId(s));
            return n;
        }
        if (this.getQuery() != null && this.getQuery().getBaseURI() != null) {
            try {
                uriStr = RelURI.resolve(uriStr, this.getQuery().getBaseURI());
            }
            catch (JenaURIException ex) {
                throw new QueryParseException(ParserBase.exMsg(ex.getMessage(), line, column));
            }
        }
        return Node.createURI((String)uriStr);
    }

    protected Node createBNode() {
        return this.activeLabelMap.allocNode();
    }

    protected Node createBNode(String label, int line, int column) {
        label = this.unescapeCodePoint(label, line, column);
        return this.activeLabelMap.asNode(label);
    }

    protected String fixupQName(String qname, int line, int column) {
        String s = this.getQuery().expandQName(qname);
        if (s == null) {
            String msg = "Line " + line + ", column " + column;
            throw new QNameException(msg + ": Unresolved qname: " + qname);
        }
        return s;
    }

    protected String fixupPrefix(String prefix, int line, int column) {
        if (prefix.endsWith(":")) {
            prefix = prefix.substring(0, prefix.length() - 1);
        }
        return prefix;
    }

    protected void insert(TripleCollector acc, Node s, Node p, Node o) {
        acc.addTriple(new Triple(s, p, o));
    }

    protected void insert(TripleCollector acc, int index, Node s, Node p, Node o) {
        acc.addTriple(index, new Triple(s, p, o));
    }

    protected Expr asExpr(Node n) {
        if (n.isVariable()) {
            return new NodeVar(n.getName());
        }
        return NodeValue.makeNode(n);
    }

    public static String unescapeStr(String s) {
        return ParserBase.unescape(s, '\\', false, 1, 1);
    }

    public static String unescapeCodePoint(String s) {
        return ParserBase.unescape(s, '\\', true, 1, 1);
    }

    protected String unescapeCodePoint(String s, int line, int column) {
        return ParserBase.unescape(s, '\\', true, line, column);
    }

    protected String unescapeStr(String s, int line, int column) {
        return ParserBase.unescape(s, '\\', false, line, column);
    }

    private static String unescape(String s, char escape, boolean pointCodeOnly, int line, int column) {
        int i = s.indexOf(escape);
        if (i == -1) {
            return s;
        }
        StringBuffer sb = new StringBuffer(s.substring(0, i));
        while (i < s.length()) {
            char ch = s.charAt(i);
            switch (ch) {
                case '\n': 
                case '\r': {
                    ++line;
                    column = 1;
                    break;
                }
                default: {
                    ++column;
                }
            }
            if (ch != escape) {
                sb.append(ch);
            } else {
                int x;
                if (i >= s.length() - 1) {
                    throw new QueryParseException(ParserBase.exMsg("Illegal escape at end of string", line, column));
                }
                char ch2 = s.charAt(i + 1);
                ++column;
                ++i;
                if (ch2 == 'u') {
                    if (i + 4 >= s.length()) {
                        throw new QueryParseException(ParserBase.exMsg("\\u escape too short", line, column));
                    }
                    x = ParserBase.hex(s, i + 1, 4, line, column);
                    sb.append((char)x);
                    i += 4;
                    column += 4;
                } else if (ch2 == 'U') {
                    if (i + 8 >= s.length()) {
                        throw new QueryParseException(ParserBase.exMsg("\\U escape too short", line, column));
                    }
                    x = ParserBase.hex(s, i + 1, 8, line, column);
                    sb.append((char)x);
                    i += 8;
                    column += 8;
                } else if (pointCodeOnly) {
                    sb.append('\\');
                    sb.append(ch2);
                    ++i;
                } else {
                    char ch3 = '\u0000';
                    switch (ch2) {
                        case 'n': {
                            ch3 = '\n';
                            break;
                        }
                        case 't': {
                            ch3 = '\t';
                            break;
                        }
                        case 'r': {
                            ch3 = '\r';
                            break;
                        }
                        case 'b': {
                            ch3 = '\b';
                            break;
                        }
                        case 'f': {
                            ch3 = '\f';
                            break;
                        }
                        case '\'': {
                            ch3 = '\'';
                            break;
                        }
                        case '\"': {
                            ch3 = '\"';
                            break;
                        }
                        case '\\': {
                            ch3 = '\\';
                            break;
                        }
                        default: {
                            throw new QueryParseException(ParserBase.exMsg("Unknown escape: \\" + ch2, line, column));
                        }
                    }
                    sb.append(ch3);
                }
            }
            ++i;
        }
        return sb.toString();
    }

    private static int hex(String s, int i, int len, int line, int column) {
        if (i + len >= s.length()) {
            // empty if block
        }
        int x = 0;
        for (int j = i; j < i + len; ++j) {
            char ch = s.charAt(j);
            ++column;
            int k = 0;
            switch (ch) {
                case '0': {
                    k = 0;
                    break;
                }
                case '1': {
                    k = 1;
                    break;
                }
                case '2': {
                    k = 2;
                    break;
                }
                case '3': {
                    k = 3;
                    break;
                }
                case '4': {
                    k = 4;
                    break;
                }
                case '5': {
                    k = 5;
                    break;
                }
                case '6': {
                    k = 6;
                    break;
                }
                case '7': {
                    k = 7;
                    break;
                }
                case '8': {
                    k = 8;
                    break;
                }
                case '9': {
                    k = 9;
                    break;
                }
                case 'A': 
                case 'a': {
                    k = 10;
                    break;
                }
                case 'B': 
                case 'b': {
                    k = 11;
                    break;
                }
                case 'C': 
                case 'c': {
                    k = 12;
                    break;
                }
                case 'D': 
                case 'd': {
                    k = 13;
                    break;
                }
                case 'E': 
                case 'e': {
                    k = 14;
                    break;
                }
                case 'F': 
                case 'f': {
                    k = 15;
                    break;
                }
                default: {
                    throw new QueryParseException(ParserBase.exMsg("Illegal hex escape: " + ch, line, column));
                }
            }
            x = (x << 4) + k;
        }
        return x;
    }

    protected static String exMsg(String msg, int line, int column) {
        return "Line " + line + ", column " + column + ": " + msg;
    }
}

