/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.query.lang;

import java.io.StringReader;
import mx.com.hp.hpl.jena.query.Constants;
import mx.com.hp.hpl.jena.query.Query;
import mx.com.hp.hpl.jena.query.QueryParseException;
import mx.com.hp.hpl.jena.query.Syntax;
import mx.com.hp.hpl.jena.query.lang.Parser;
import mx.com.hp.hpl.jena.query.lang.rdql.ParseException;
import mx.com.hp.hpl.jena.query.lang.rdql.Q_Query;
import mx.com.hp.hpl.jena.query.lang.rdql.RDQLParser;
import mx.com.hp.hpl.jena.query.util.PrefixMapping2;
import mx.com.hp.hpl.jena.query.util.RelURI;

class ParserRDQL
extends Parser {
    ParserRDQL() {
    }

    public Query parse(Query q, String s) {
        q.setSyntax(Syntax.syntaxRDQL);
        PrefixMapping2 pm = new PrefixMapping2(Constants.getGlobalPrefixMap(), q.getPrefixMapping());
        q.setPrefixMapping(pm);
        q.getPrefixMapping().setNsPrefixes(Constants.getGlobalPrefixMap());
        Q_Query query2 = null;
        try {
            StringReader in = new StringReader(s);
            RDQLParser parser = new RDQLParser(in);
            parser.CompilationUnit();
            query2 = (Q_Query)parser.top();
            query2.rdqlPhase2(q);
            if (q.getGraphURIs() != null) {
                for (int i = 0; i < q.getGraphURIs().size(); ++i) {
                    String u = (String)q.getGraphURIs().get(i);
                    u = RelURI.resolve(u, q.getBaseURI());
                    q.getGraphURIs().set(i, u);
                }
            }
            return q;
        }
        catch (QueryParseException qEx) {
            throw qEx;
        }
        catch (ParseException ex) {
            throw new QueryParseException("Parse error: " + ex.getMessage());
        }
        catch (Error e2) {
            throw new QueryParseException("Parse error: " + e2.getMessage());
        }
        catch (Exception e3) {
            throw new QueryParseException("Unexpected exception: " + e3.getMessage());
        }
    }
}

