/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.query.lang.rdql;

import java.util.Set;
import mx.com.hp.hpl.jena.graph.query.Expression;
import mx.com.hp.hpl.jena.graph.query.IndexValues;
import mx.com.hp.hpl.jena.graph.query.Valuator;
import mx.com.hp.hpl.jena.graph.query.VariableIndexes;
import mx.com.hp.hpl.jena.query.Query;
import mx.com.hp.hpl.jena.query.core.Binding;
import mx.com.hp.hpl.jena.query.core.BindingIndex;
import mx.com.hp.hpl.jena.query.core.Constraint;
import mx.com.hp.hpl.jena.query.engine1.ExecutionContext;
import mx.com.hp.hpl.jena.query.lang.rdql.Expr;
import mx.com.hp.hpl.jena.query.lang.rdql.Node;
import mx.com.hp.hpl.jena.query.lang.rdql.NodeValue;
import mx.com.hp.hpl.jena.query.lang.rdql.Q_Var;
import mx.com.hp.hpl.jena.query.lang.rdql.RDQLEvalFailureException;
import mx.com.hp.hpl.jena.query.lang.rdql.RDQLParser;
import mx.com.hp.hpl.jena.query.lang.rdql.SimpleNode;
import mx.com.hp.hpl.jena.query.util.IndentedWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

abstract class ExprNode
extends SimpleNode
implements Expression,
Valuator,
Constraint,
Expr {
    static Log log = LogFactory.getLog((Class)ExprNode.class);
    static final String exprBaseURI = "urn:x-jena:expr:";

    public ExprNode(RDQLParser p, int i) {
        super(p, i);
    }

    public ExprNode(int i) {
        super(i);
    }

    public boolean isSatisfied(Binding binding, ExecutionContext execCxt) {
        BindingIndex bInd;
        BindingIndex vi = bInd = new BindingIndex(binding);
        this.prepare(vi);
        BindingIndex iv = bInd;
        return this.isSatisfied(iv);
    }

    public boolean isSatisfied(IndexValues env) {
        return this.evalBool(env);
    }

    public void postParse2(Query q) {
        super.postParse2(q);
    }

    public void varsMentioned(Set acc) {
        if (this instanceof Q_Var) {
            Q_Var v = (Q_Var)this;
            acc.add(v.getName());
            return;
        }
        for (int i = 0; i < this.argCount(); ++i) {
            Expression e2 = this.getArg(i);
            if (e2 == null) continue;
            ExprNode ex = (ExprNode)e2;
            ex.varsMentioned(acc);
        }
    }

    public Valuator prepare(VariableIndexes vi) {
        if (this.children != null) {
            for (int i = 0; i < this.children.length; ++i) {
                Node n = this.children[i];
                if (!(n instanceof Expression)) continue;
                ((Expression)n).prepare(vi);
            }
        }
        return this;
    }

    public Object evalObject(IndexValues iv) {
        return this.evalNode(null, iv);
    }

    public boolean evalBool(IndexValues iv) {
        return this.evalBool(null, iv);
    }

    protected boolean evalBool(Query q, IndexValues iv) {
        NodeValue v = this.evalNode(q, iv);
        return v == null ? false : v.getBoolean();
    }

    public NodeValue evalNode(Query q, IndexValues env) {
        try {
            return this.eval(q, env);
        }
        catch (RDQLEvalFailureException e2) {
            return null;
        }
        catch (Exception e3) {
            log.warn((Object)"RDQL : general exception!", (Throwable)e3);
            return null;
        }
    }

    public boolean isVariable() {
        return false;
    }

    public String getName() {
        return null;
    }

    public boolean isConstant() {
        return false;
    }

    public Object getValue() {
        return null;
    }

    public boolean isApply() {
        return false;
    }

    public String getFun() {
        return null;
    }

    public int argCount() {
        return 0;
    }

    public Expression getArg(int i) {
        return null;
    }

    protected String constructURI(String className) {
        if (className.lastIndexOf(46) > -1) {
            className = className.substring(className.lastIndexOf(46) + 1);
        }
        return exprBaseURI + className;
    }

    public void format(Query query2, IndentedWriter writer) {
        this.format(writer);
    }

    public abstract void format(IndentedWriter var1);

    public String toString() {
        return this.asInfixString();
    }
}

