/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.query.lang.rdql;

import mx.com.hp.hpl.jena.graph.query.Expression;
import mx.com.hp.hpl.jena.graph.query.IndexValues;
import mx.com.hp.hpl.jena.query.Query;
import mx.com.hp.hpl.jena.query.QueryException;
import mx.com.hp.hpl.jena.query.lang.rdql.Expr;
import mx.com.hp.hpl.jena.query.lang.rdql.ExprBoolean;
import mx.com.hp.hpl.jena.query.lang.rdql.ExprNode;
import mx.com.hp.hpl.jena.query.lang.rdql.NodeValue;
import mx.com.hp.hpl.jena.query.lang.rdql.NodeValueSettable;
import mx.com.hp.hpl.jena.query.lang.rdql.RDQLEvalTypeException;
import mx.com.hp.hpl.jena.query.lang.rdql.RDQLParser;
import mx.com.hp.hpl.jena.query.lang.rdql.RDQLQueryPrintUtils;
import mx.com.hp.hpl.jena.query.lang.rdql.WorkingVar;
import mx.com.hp.hpl.jena.query.util.IndentedWriter;

public class Q_LogicalAnd
extends ExprNode
implements Expr,
ExprBoolean {
    Expr left;
    Expr right;
    private String printName = "and";
    private String opSymbol = "&&";

    Q_LogicalAnd(int id) {
        super(id);
    }

    Q_LogicalAnd(RDQLParser p, int id) {
        super(p, id);
    }

    public NodeValue eval(Query q, IndexValues env) {
        NodeValue x = this.left.eval(q, env);
        NodeValue y = this.right.eval(q, env);
        if (!x.isBoolean()) {
            throw new RDQLEvalTypeException("Q_LogicalAnd: Wanted a boolean: " + x);
        }
        if (!y.isBoolean()) {
            throw new RDQLEvalTypeException("Q_LogicalAnd: Wanted a boolean: " + y);
        }
        NodeValueSettable result = x instanceof NodeValueSettable ? (NodeValueSettable)x : (y instanceof NodeValueSettable ? (NodeValueSettable)y : new WorkingVar());
        boolean b = x.getBoolean() && y.getBoolean();
        result.setBoolean(b);
        return result;
    }

    public void jjtClose() {
        int n = this.jjtGetNumChildren();
        if (n != 2) {
            throw new QueryException("Q_LogicalAnd: Wrong number of children: " + n);
        }
        this.left = (Expr)((Object)this.jjtGetChild(0));
        this.right = (Expr)((Object)this.jjtGetChild(1));
    }

    public boolean isApply() {
        return true;
    }

    public String getFun() {
        return super.constructURI(this.getClass().getName());
    }

    public int argCount() {
        return 2;
    }

    public Expression getArg(int i) {
        if (i == 0 && this.left instanceof Expression) {
            return (Expression)this.left;
        }
        if (i == 1 && this.right instanceof Expression) {
            return (Expression)this.right;
        }
        return null;
    }

    public String asInfixString() {
        return RDQLQueryPrintUtils.asInfixString2(this.left, this.right, this.printName, this.opSymbol);
    }

    public String asPrefixString() {
        return RDQLQueryPrintUtils.asPrefixString(this.left, this.right, this.printName, this.opSymbol);
    }

    public void format(IndentedWriter w) {
        RDQLQueryPrintUtils.format(w, this.left, this.right, this.printName, this.opSymbol);
    }

    public String toString() {
        return this.asInfixString();
    }
}

