/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.query.lang.rdql;

import mx.com.hp.hpl.jena.datatypes.RDFDatatype;
import mx.com.hp.hpl.jena.datatypes.TypeMapper;
import mx.com.hp.hpl.jena.query.Query;
import mx.com.hp.hpl.jena.query.lang.rdql.Node;
import mx.com.hp.hpl.jena.query.lang.rdql.ParsedLiteral;
import mx.com.hp.hpl.jena.query.lang.rdql.Q_Identifier;
import mx.com.hp.hpl.jena.query.lang.rdql.Q_URI;
import mx.com.hp.hpl.jena.query.lang.rdql.RDQLParser;

public class Q_TextLiteral
extends ParsedLiteral {
    Q_URI datatype = null;
    String langTag = null;
    String seen = null;

    Q_TextLiteral(int id) {
        super(id);
    }

    Q_TextLiteral(RDQLParser p, int id) {
        super(p, id);
    }

    void set(String s) {
        this.seen = s;
        s = s.substring(1, s.length() - 1);
        super._setString(Q_TextLiteral.unescape(s, '\\'));
    }

    public void jjtClose() {
        int n = this.jjtGetNumChildren();
        for (int i = 0; i < n; ++i) {
            Node node = this.jjtGetChild(i);
            if (node instanceof Q_Identifier) {
                this.langTag = ((Q_Identifier)node).idName;
            }
            if (!(node instanceof Q_URI)) continue;
            this.datatype = (Q_URI)node;
        }
        if (this.langTag != null) {
            this.seen = this.seen + "@" + this.langTag;
        }
        if (this.datatype != null) {
            this.seen = this.seen + "^^" + this.datatype.asQuotedString();
        }
    }

    public void postParse2(Query query2) {
        super.postParse2(query2);
        String tmp_datatype = null;
        if (this.datatype != null) {
            this.datatype.postParse2(query2);
            tmp_datatype = this.datatype.getURI();
        }
        mx.com.hp.hpl.jena.graph.Node n = null;
        if (tmp_datatype != null) {
            RDFDatatype dType = TypeMapper.getInstance().getSafeTypeByName(tmp_datatype);
            n = mx.com.hp.hpl.jena.graph.Node.createLiteral((String)super.getString(), null, (RDFDatatype)dType);
        } else {
            n = mx.com.hp.hpl.jena.graph.Node.createLiteral((String)super.getString(), (String)this.langTag, null);
        }
        super._setNode(n);
    }

    public String asQuotedString() {
        return this.seen;
    }

    static String unescape(String s, char escape) {
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) != escape || i >= s.length() - 1) continue;
            char ch2 = s.charAt(i + 1);
            if (ch2 == 'n') {
                ch2 = '\n';
            }
            if (ch2 == 't') {
                ch2 = '\t';
            }
            if (ch2 == 'r') {
                ch2 = '\r';
            }
            if (ch2 == 'b') {
                ch2 = '\b';
            }
            s = s.substring(0, i) + ch2 + s.substring(i + 2);
        }
        return s;
    }
}

