/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.query.lang.rdql;

import mx.com.hp.hpl.jena.graph.query.Expression;
import mx.com.hp.hpl.jena.graph.query.IndexValues;
import mx.com.hp.hpl.jena.query.Query;
import mx.com.hp.hpl.jena.query.QueryException;
import mx.com.hp.hpl.jena.query.lang.rdql.Expr;
import mx.com.hp.hpl.jena.query.lang.rdql.ExprNode;
import mx.com.hp.hpl.jena.query.lang.rdql.ExprNumeric;
import mx.com.hp.hpl.jena.query.lang.rdql.NodeValue;
import mx.com.hp.hpl.jena.query.lang.rdql.RDQLEvalTypeException;
import mx.com.hp.hpl.jena.query.lang.rdql.RDQLParser;
import mx.com.hp.hpl.jena.query.lang.rdql.RDQLQueryPrintUtils;
import mx.com.hp.hpl.jena.query.lang.rdql.WorkingVar;
import mx.com.hp.hpl.jena.query.util.IndentedWriter;

public class Q_UnaryMinus
extends ExprNode
implements ExprNumeric {
    Expr expr;
    private String printName = "unaryminus";
    private String opSymbol = "-";

    Q_UnaryMinus(int id) {
        super(id);
    }

    Q_UnaryMinus(RDQLParser p, int id) {
        super(p, id);
    }

    public NodeValue eval(Query q, IndexValues env) {
        NodeValue v = this.expr.eval(q, env);
        if (!v.isNumber()) {
            throw new RDQLEvalTypeException("Q_UnaryMinus: Wanted a number: got " + this.expr);
        }
        WorkingVar result = new WorkingVar();
        if (v.isInt()) {
            result.setInt(-v.getInt());
        } else {
            result.setDouble(-v.getDouble());
        }
        return result;
    }

    public void jjtClose() {
        int n = this.jjtGetNumChildren();
        if (n != 1) {
            throw new QueryException("Q_UnaryMinus: Wrong number of children: " + n);
        }
        this.expr = (Expr)((Object)this.jjtGetChild(0));
    }

    public boolean isApply() {
        return true;
    }

    public String getFun() {
        return super.constructURI(this.getClass().getName());
    }

    public int argCount() {
        return 1;
    }

    public Expression getArg(int i) {
        if (i == 0 && this.expr instanceof Expression) {
            return (Expression)this.expr;
        }
        return null;
    }

    public String asInfixString() {
        return RDQLQueryPrintUtils.asInfixString1(this.expr, this.printName, this.opSymbol);
    }

    public String asPrefixString() {
        return RDQLQueryPrintUtils.asPrefixString(this.expr, null, this.printName, this.opSymbol);
    }

    public void format(IndentedWriter w) {
        RDQLQueryPrintUtils.format(w, this.expr, null, this.printName, this.opSymbol);
    }

    public String toString() {
        return this.asInfixString();
    }
}

