/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.query.lang.rdql;

import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import mx.com.hp.hpl.jena.query.lang.rdql.Expr;
import mx.com.hp.hpl.jena.query.util.IndentedWriter;
import mx.com.hp.hpl.jena.shared.PrefixMapping;

public class RDQLQueryPrintUtils {
    static final String indentPrefix = "  ";
    public static boolean multiLineExpr = false;
    public static boolean printOpName = true;
    static int bNodeCounter = 0;
    static Map bNodeStrings = new HashMap();
    static PrefixMapping prefixes = PrefixMapping.Factory.create().setNsPrefixes(PrefixMapping.Standard).setNsPrefix("xsd", "http://www.w3.org/2001/XMLSchema#");
    static final int indent = 2;

    public static void print(PrintWriter pw, Expr expr) {
        pw.println(expr.asPrefixString());
    }

    public static String asInfixString1(Expr expr, String opName, String symbol) {
        StringBuffer sb = new StringBuffer();
        sb.append("(");
        sb.append(symbol);
        sb.append(" ");
        sb.append(expr.asInfixString());
        sb.append(")");
        return sb.toString();
    }

    public static String asInfixString2(Expr left, Expr right, String opName, String symbol) {
        StringBuffer sb = new StringBuffer();
        sb.append("( ");
        sb.append(left.asInfixString());
        sb.append(" ");
        sb.append(symbol);
        sb.append(" ");
        sb.append(right.asInfixString());
        sb.append(" )");
        return sb.toString();
    }

    public static String asPrefixString(Expr left, Expr right, String opName, String symbol) {
        StringBuffer sb = new StringBuffer();
        sb.append("(");
        sb.append(printOpName ? opName : symbol);
        sb.append(" ");
        sb.append(left.asPrefixString());
        if (right != null) {
            sb.append(" ");
            sb.append(right.asPrefixString());
        }
        sb.append(")");
        return sb.toString();
    }

    public static void format(IndentedWriter w, Expr left, Expr right, String opName, String symbol) {
        w.print("( ");
        if (right == null) {
            w.print(symbol);
            left.format(w);
        } else {
            left.format(w);
            w.print(" ");
            w.print(symbol);
            w.print(" ");
            right.format(w);
        }
        w.print(" )");
    }
}

