/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.query.resultset;

import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import mx.com.hp.hpl.jena.graph.Node;
import mx.com.hp.hpl.jena.query.Query;
import mx.com.hp.hpl.jena.query.QueryExecException;
import mx.com.hp.hpl.jena.query.SortCondition;
import mx.com.hp.hpl.jena.query.core.Binding;
import mx.com.hp.hpl.jena.query.engine1.ExecutionContext;
import mx.com.hp.hpl.jena.query.expr.ExprEvalException;
import mx.com.hp.hpl.jena.query.expr.NodeValue;
import mx.com.hp.hpl.jena.query.util.NodeUtils;

public class BindingComparator
implements Comparator {
    List conditions;
    ExecutionContext execCxt;

    public BindingComparator(List _conditions, ExecutionContext execCxt) {
        this.conditions = _conditions;
        this.execCxt = execCxt;
    }

    public BindingComparator(List _conditions) {
        this.conditions = _conditions;
        this.execCxt = null;
    }

    public int compare(Object arg1, Object arg2) {
        Binding bind1 = (Binding)arg1;
        Binding bind2 = (Binding)arg2;
        Iterator iter = this.conditions.iterator();
        while (iter.hasNext()) {
            int x = -9999;
            SortCondition sc = (SortCondition)iter.next();
            if (sc.variable != null) {
                String vn = sc.variable.getName();
                Node n1 = bind1.get(vn);
                Node n2 = bind2.get(vn);
                x = NodeUtils.compareNodesByValue(n1, n2);
            } else if (sc.expression != null) {
                NodeValue nv1 = null;
                NodeValue nv2 = null;
                try {
                    nv1 = sc.expression.eval(bind1, this.execCxt);
                }
                catch (ExprEvalException ex) {
                    // empty catch block
                }
                try {
                    nv2 = sc.expression.eval(bind2, this.execCxt);
                }
                catch (ExprEvalException ex) {
                    // empty catch block
                }
                Node n1 = NodeValue.toNode(nv1);
                Node n2 = NodeValue.toNode(nv2);
                x = NodeUtils.compareNodesByValue(n1, n2);
            } else {
                throw new QueryExecException("Broken sort condition");
            }
            if (x == 0) continue;
            if (sc.direction == Query.DESCENDING) {
                x = -x;
            }
            return x;
        }
        return BindingComparator.compareBindings(bind1, bind2);
    }

    public static int compareBindings(Binding bind1, Binding bind2) {
        int x = 0;
        Iterator iter = bind1.names();
        while (iter.hasNext()) {
            Node n2;
            String name = (String)iter.next();
            Node n1 = bind1.get(name);
            x = NodeUtils.compareNodesByKindTypeLexical(n1, n2 = bind2.get(name));
            if (x == 0) continue;
            return x;
        }
        return x;
    }
}

