/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.query.resultset;

import java.util.Iterator;
import mx.com.hp.hpl.jena.datatypes.RDFDatatype;
import mx.com.hp.hpl.jena.datatypes.xsd.XSDDatatype;
import mx.com.hp.hpl.jena.query.QuerySolution;
import mx.com.hp.hpl.jena.query.ResultSet;
import mx.com.hp.hpl.jena.query.vocabulary.ResultSetVocab;
import mx.com.hp.hpl.jena.rdf.model.Literal;
import mx.com.hp.hpl.jena.rdf.model.Model;
import mx.com.hp.hpl.jena.rdf.model.ModelFactory;
import mx.com.hp.hpl.jena.rdf.model.RDFNode;
import mx.com.hp.hpl.jena.rdf.model.Resource;
import mx.com.hp.hpl.jena.vocabulary.RDF;

public class RDFOutput {
    boolean reportAllVars = false;

    public boolean getAllVars() {
        return this.reportAllVars;
    }

    public void setAllVars(boolean all) {
        this.reportAllVars = all;
    }

    public Model toModel(ResultSet resultSet) {
        Model m = ModelFactory.createDefaultModel();
        this.asRDF(m, resultSet);
        if (m.getNsPrefixURI("rs") == null) {
            m.setNsPrefix("rs", ResultSetVocab.getURI());
        }
        if (m.getNsPrefixURI("rdf") == null) {
            m.setNsPrefix("rdf", RDF.getURI());
        }
        return m;
    }

    public Resource asRDF(Model model, ResultSet resultSet) {
        Resource results = model.createResource();
        results.addProperty(RDF.type, (RDFNode)ResultSetVocab.ResultSet);
        Iterator iter = resultSet.getResultVars().iterator();
        while (iter.hasNext()) {
            String vName = (String)iter.next();
            results.addProperty(ResultSetVocab.resultVariable, vName);
        }
        int count = 0;
        while (resultSet.hasNext()) {
            Iterator iter2;
            ++count;
            QuerySolution rBind = resultSet.nextSolution();
            Resource thisSolution = model.createResource();
            results.addProperty(ResultSetVocab.solution, (RDFNode)thisSolution);
            Iterator iterator = iter2 = this.getAllVars() ? rBind.varNames() : resultSet.getResultVars().iterator();
            while (iter2.hasNext()) {
                Resource thisBinding = model.createResource();
                String rVar = (String)iter2.next();
                RDFNode n = rBind.get(rVar);
                if (n == null) continue;
                thisBinding.addProperty(ResultSetVocab.variable, rVar);
                thisBinding.addProperty(ResultSetVocab.value, n);
                thisSolution.addProperty(ResultSetVocab.binding, (RDFNode)thisBinding);
                if (!resultSet.isOrdered()) continue;
                Literal i = model.createTypedLiteral(Integer.toString(count), (RDFDatatype)XSDDatatype.XSDinteger);
                thisSolution.addProperty(ResultSetVocab.index, (RDFNode)i);
            }
        }
        return results;
    }
}

