/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.query.resultset;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import mx.com.hp.hpl.jena.query.QuerySolution;
import mx.com.hp.hpl.jena.query.ResultSet;
import mx.com.hp.hpl.jena.query.resultset.ResultSetRewindable;
import mx.com.hp.hpl.jena.query.util.Utils;

public class ResultSetMem
implements ResultSetRewindable {
    protected List rows = new ArrayList();
    protected List varNames = null;
    protected boolean ordered = false;
    protected boolean distinct = false;
    private int rowNumber = 0;
    private Iterator iterator = null;

    public ResultSetMem(ResultSetMem imrs2) {
        this(imrs2, false);
    }

    public ResultSetMem(ResultSetMem imrs2, boolean takeCopy) {
        this.varNames = imrs2.varNames;
        this.ordered = imrs2.ordered;
        this.distinct = imrs2.distinct;
        if (takeCopy) {
            this.rows.addAll(imrs2.rows);
        } else {
            this.rows = imrs2.rows;
        }
        this.reset();
    }

    public ResultSetMem(ResultSet qr) {
        this.ordered = qr.isOrdered();
        this.distinct = qr.isDistinct();
        if (qr instanceof ResultSetMem) {
            ResultSetMem qrm = (ResultSetMem)qr;
            this.rows = qrm.rows;
            this.varNames = qrm.varNames;
        } else {
            this.varNames = qr.getResultVars();
            while (qr.hasNext()) {
                QuerySolution rb = qr.nextSolution();
                this.rows.add(rb);
            }
        }
        this.reset();
    }

    public ResultSetMem() {
        this.varNames = new ArrayList();
        this.reset();
    }

    public void remove() throws UnsupportedOperationException {
        throw new UnsupportedOperationException(Utils.className(this) + ": Attempt to remove an element");
    }

    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    public QuerySolution nextSolution() {
        ++this.rowNumber;
        return (QuerySolution)this.iterator.next();
    }

    public Object next() {
        return this.nextSolution();
    }

    public void rewind() {
        this.reset();
    }

    public void reset() {
        this.iterator = this.rows.iterator();
        this.rowNumber = 0;
    }

    public int getRowNumber() {
        return this.rowNumber;
    }

    public int size() {
        return this.rows.size();
    }

    public boolean isOrdered() {
        return this.ordered;
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public List getResultVars() {
        return this.varNames;
    }
}

