/*
 * Decompiled with CFR 0.152.
 */
package mx.com.hp.hpl.jena.query.resultset;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import mx.com.hp.hpl.jena.datatypes.RDFDatatype;
import mx.com.hp.hpl.jena.datatypes.TypeMapper;
import mx.com.hp.hpl.jena.graph.Node;
import mx.com.hp.hpl.jena.query.QuerySolution;
import mx.com.hp.hpl.jena.query.ResultSet;
import mx.com.hp.hpl.jena.query.core.Binding;
import mx.com.hp.hpl.jena.query.core.BindingMap;
import mx.com.hp.hpl.jena.query.core.ResultBinding;
import mx.com.hp.hpl.jena.query.resultset.ResultSetException;
import mx.com.hp.hpl.jena.query.resultset.XMLResults;
import mx.com.hp.hpl.jena.query.util.LabelToNodeMap;
import mx.com.hp.hpl.jena.query.util.StringUtils;
import mx.com.hp.hpl.jena.rdf.model.Model;
import mx.com.hp.hpl.jena.rdf.model.ModelFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class XMLInputStAX
implements ResultSet,
XMLResults {
    private static Log log = LogFactory.getLog((Class)XMLInputStAX.class);
    QuerySolution current = null;
    XMLStreamReader parser = null;
    List variables = new ArrayList();
    Binding binding = null;
    LabelToNodeMap bNodes = new LabelToNodeMap(false);
    boolean isResultSet = false;
    boolean ordered = false;
    boolean distinct = false;
    boolean finished = false;
    Model model = null;
    int row = 0;
    private boolean isBooleanResult = false;
    boolean askResult = false;

    public static ResultSet fromXML(InputStream in) {
        return XMLInputStAX.fromXML(in, null);
    }

    public static ResultSet fromXML(InputStream in, Model model) {
        XMLInputStAX x = new XMLInputStAX(in, model);
        if (!x.isResultSet) {
            throw new ResultSetException("Not a result set");
        }
        return x;
    }

    public XMLInputStAX(InputStream in) {
        this(in, ModelFactory.createDefaultModel());
    }

    public XMLInputStAX(InputStream in, Model model) {
        this.model = model;
        try {
            XMLInputFactory xf = XMLInputFactory.newInstance();
            this.parser = xf.createXMLStreamReader(in);
            this.skipTo("head");
            this.processHead();
            this.skipTo(new String[]{"results", "boolean"}, new String[]{"results"});
            String tag = this.parser.getLocalName();
            if (tag.equals("results")) {
                this.isResultSet = true;
                this.processResults();
            }
            if (tag.equals("boolean")) {
                this.isBooleanResult = true;
                this.processBoolean();
            }
        }
        catch (XMLStreamException ex) {
            log.warn((Object)("XMLStreamException: " + ex.getMessage()), (Throwable)ex);
        }
    }

    public boolean hasNext() {
        if (!this.isResultSet) {
            throw new ResultSetException("Not an XML result set");
        }
        try {
            if (this.finished) {
                return false;
            }
            if (this.binding == null) {
                this.binding = this.getOneSolution();
            }
        }
        catch (XMLStreamException ex) {
            this.staxError("XMLStreamException: " + ex.getMessage(), ex);
        }
        ++this.row;
        return this.binding != null;
    }

    public Object next() {
        return this.nextSolution();
    }

    public QuerySolution nextSolution() {
        if (this.finished) {
            throw new NoSuchElementException("End of XML Results");
        }
        if (!this.hasNext()) {
            throw new NoSuchElementException("End of XML Results");
        }
        ResultBinding currentEnv = new ResultBinding(this.model, this.binding);
        this.binding = null;
        return currentEnv;
    }

    public int getRowNumber() {
        return this.row;
    }

    public List getResultVars() {
        return this.variables;
    }

    public boolean isOrdered() {
        return this.ordered;
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public void remove() {
        throw new UnsupportedOperationException(XMLInputStAX.class.getName());
    }

    public boolean getBooleanResult() {
        if (!this.isBooleanResult) {
            throw new ResultSetException("Not an XML boolean result");
        }
        return this.askResult;
    }

    private void processBoolean() throws XMLStreamException {
        String s = this.parser.getElementText();
        if (s.equalsIgnoreCase("true")) {
            this.askResult = true;
            return;
        }
        if (s.equalsIgnoreCase("false")) {
            this.askResult = true;
            return;
        }
        throw new ResultSetException("Unknown boolean value: " + s);
    }

    private void skipTo(String tag1) throws XMLStreamException {
        this.skipTo(new String[]{tag1}, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void skipTo(String[] startElementNames, String[] stopElementNames) throws XMLStreamException {
        boolean found = false;
        block5: while (this.parser.hasNext()) {
            int event = this.parser.next();
            switch (event) {
                case 8: {
                    break block5;
                }
                case 2: {
                    String endTag;
                    if (stopElementNames == null || (endTag = this.parser.getLocalName()) == null || !this.containsName(stopElementNames, endTag)) break;
                    return;
                }
                case 1: {
                    if (startElementNames == null) break;
                    QName qname = this.parser.getName();
                    if (!qname.getNamespaceURI().equals("http://www.w3.org/2005/sparql-results#")) {
                        this.staxError("skipToHead: Unexpected tag: " + qname);
                    }
                    if (!this.containsName(startElementNames, qname.getLocalPart())) break;
                    return;
                }
            }
        }
        if (!found) {
            String s1 = "";
            if (startElementNames != null) {
                s1 = StringUtils.join(", ", startElementNames);
            }
            String s2 = "";
            if (stopElementNames != null) {
                s2 = StringUtils.join(", ", stopElementNames);
            }
            log.warn((Object)("Failed to find start of stop of specified elements: " + s1 + " :: " + s2));
        }
    }

    private boolean containsName(String[] elementNames, String eName) {
        for (int i = 0; i < elementNames.length; ++i) {
            String s = elementNames[i];
            if (!s.equals(eName)) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void processHead() throws XMLStreamException {
        while (this.parser.hasNext()) {
            int event = this.parser.next();
            String tag = null;
            switch (event) {
                case 8: {
                    return;
                }
                case 2: {
                    tag = this.parser.getLocalName();
                    if (!this.isTag(tag, "head")) break;
                    return;
                }
                case 1: {
                    tag = this.parser.getLocalName();
                    if (this.isTag(tag, "head")) break;
                    if (this.isTag(tag, "variable")) {
                        String varname = this.parser.getAttributeValue(null, "name");
                        this.variables.add(varname);
                        break;
                    }
                    if (this.isTag(tag, "link")) break;
                    this.staxError("Unknown XML element: " + tag);
                }
            }
        }
    }

    private void processResults() throws XMLStreamException {
        String s = this.parser.getAttributeValue(null, "ordered");
        if (s != null && s.equals("true")) {
            this.ordered = true;
        }
        if ((s = this.parser.getAttributeValue(null, "distinct")) != null && s.equals("true")) {
            this.distinct = true;
        }
    }

    private Binding getOneSolution() throws XMLStreamException {
        BindingMap binding = new BindingMap();
        String varName = null;
        while (this.parser.hasNext()) {
            int event = this.parser.next();
            String tag = null;
            switch (event) {
                case 8: {
                    this.staxError("End of document while processing solution");
                    return null;
                }
                case 2: {
                    tag = this.parser.getLocalName();
                    if (this.isTag(tag, "result")) {
                        return binding;
                    }
                    if (!this.isTag(tag, "results")) break;
                    return null;
                }
                case 1: {
                    Node node;
                    tag = this.parser.getLocalName();
                    if (this.isTag(tag, "result")) {
                        binding = new BindingMap();
                        break;
                    }
                    if (this.isTag(tag, "binding")) {
                        varName = this.parser.getAttributeValue(null, "name");
                        break;
                    }
                    if (this.isTag(tag, "bnode")) {
                        String label = this.parser.getElementText();
                        node = this.bNodes.asNode(label);
                        binding.add(varName, node);
                        break;
                    }
                    if (this.isTag(tag, "literal")) {
                        String datatype = this.parser.getAttributeValue(null, "datatype");
                        String langTag = this.parser.getAttributeValue(null, "lang");
                        String text = this.parser.getElementText();
                        RDFDatatype dType = null;
                        if (datatype != null) {
                            dType = TypeMapper.getInstance().getSafeTypeByName(datatype);
                        }
                        Node n = Node.createLiteral((String)text, (String)langTag, (RDFDatatype)dType);
                        binding.add(varName, n);
                        break;
                    }
                    if (this.isTag(tag, "unbound") || !this.isTag(tag, "uri")) break;
                    String uri = this.parser.getElementText();
                    node = Node.createURI((String)uri);
                    binding.add(varName, node);
                    break;
                }
            }
        }
        this.staxError("getOneSolution: Hit end unexpectedly");
        return null;
    }

    private boolean isTag(String localName, String expectedName) {
        if (!this.parser.getNamespaceURI().equals("http://www.w3.org/2005/sparql-results#")) {
            return false;
        }
        return localName.equals(expectedName);
    }

    private void staxError(String msg) {
        log.warn((Object)("StAX error: " + msg));
        throw new ResultSetException(msg);
    }

    private void staxError(String msg, Throwable th) {
        log.warn((Object)("StAX error: " + msg), th);
        throw new ResultSetException(msg, th);
    }
}

